/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.domain;

import java.util.UUID;
import no.difi.sdp.client2.domain.Avsender;
import no.difi.sdp.client2.domain.Dokumentpakke;
import no.difi.sdp.client2.domain.ForretningsMelding;
import no.difi.sdp.client2.domain.Mottaker;
import no.difi.sdp.client2.domain.Prioritet;
import no.difi.sdp.client2.domain.TekniskMottaker;
import no.difi.sdp.client2.domain.digital_post.DigitalPost;
import no.difi.sdp.client2.domain.fysisk_post.FysiskPost;

public class Forsendelse {
    public final Type type;
    private final DigitalPost digitalPost;
    private final FysiskPost fysiskPost;
    private final Dokumentpakke dokumentpakke;
    private final Mottaker mottaker;
    private final Avsender avsender;
    private String konversasjonsId = UUID.randomUUID().toString();
    private String spraakkode = "NO";
    private String mpcId;

    private Forsendelse(Avsender avsender, DigitalPost digitalPost, Dokumentpakke dokumentpakke, Mottaker mottaker) {
        this.mottaker = mottaker;
        this.type = Type.DIGITAL;
        this.avsender = avsender;
        this.digitalPost = digitalPost;
        this.fysiskPost = null;
        this.dokumentpakke = dokumentpakke;
    }

    private Forsendelse(Avsender avsender, FysiskPost fysiskPost, Dokumentpakke dokumentpakke, Mottaker mottaker) {
        this.mottaker = mottaker;
        this.type = Type.FYSISK;
        this.avsender = avsender;
        this.dokumentpakke = dokumentpakke;
        this.fysiskPost = fysiskPost;
        this.digitalPost = null;
    }

    public String getKonversasjonsId() {
        return this.konversasjonsId;
    }

    public DigitalPost getDigitalPost() {
        return this.digitalPost;
    }

    public FysiskPost getFysiskPost() {
        return this.fysiskPost;
    }

    public ForretningsMelding getForretningsMelding() {
        if (this.digitalPost != null) {
            return this.digitalPost;
        }
        return this.fysiskPost;
    }

    public Dokumentpakke getDokumentpakke() {
        return this.dokumentpakke;
    }

    public String getSpraakkode() {
        return this.spraakkode;
    }

    public String getMpcId() {
        return this.mpcId;
    }

    @Deprecated
    public Prioritet getPrioritet() {
        return Prioritet.NORMAL;
    }

    public Avsender getAvsender() {
        return this.avsender;
    }

    public static Builder digital(Avsender avsender, DigitalPost digitalPost, Dokumentpakke dokumentpakke) {
        return new Builder(avsender, digitalPost, dokumentpakke);
    }

    public static Builder fysisk(Avsender avsender, FysiskPost fysiskPost, Dokumentpakke dokumentpakke, Mottaker mottaker) {
        return new Builder(avsender, fysiskPost, dokumentpakke, mottaker);
    }

    public Mottaker getMottaker() {
        return this.mottaker;
    }

    public TekniskMottaker getTekniskMottaker() {
        switch (this.type) {
            case DIGITAL: {
                return this.mottaker.getMottakersPostkasse();
            }
            case FYSISK: {
                return this.fysiskPost.getUtskriftsleverandoer();
            }
        }
        throw new IllegalStateException("Forsendelse av type " + (Object)((Object)this.type) + " har ikke teknisk mottaker");
    }

    public static class Builder {
        private final Forsendelse target;
        private boolean built = false;

        private Builder(Avsender avsender, DigitalPost digitalPost, Dokumentpakke dokumentpakke) {
            this.target = new Forsendelse(avsender, digitalPost, dokumentpakke, digitalPost.getMottaker());
        }

        private Builder(Avsender avsender, FysiskPost fysiskPost, Dokumentpakke dokumentpakke, Mottaker mottaker) {
            this.target = new Forsendelse(avsender, fysiskPost, dokumentpakke, mottaker);
        }

        public Builder konversasjonsId(String konversasjonsId) {
            this.target.konversasjonsId = konversasjonsId;
            return this;
        }

        public Builder spraakkode(String spraakkode) {
            this.target.spraakkode = spraakkode;
            return this;
        }

        @Deprecated
        public Builder mpcId(String mpcId) {
            this.target.mpcId = mpcId;
            return this;
        }

        @Deprecated
        public Builder prioritet(Prioritet prioritet) {
            return this;
        }

        public Forsendelse build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.target;
        }
    }

    public static enum Type {
        DIGITAL("urn:no:difi:digitalpost:xsd:digital::digital"),
        FYSISK("urn:no:difi:digitalpost:xsd:fysisk::print");

        public final String type;

        private Type(String type) {
            this.type = type;
        }
    }
}

