/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.domain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import no.difi.sdp.client2.domain.Dokument;
import no.difi.sdp.client2.domain.MedDokumentEgenskaper;
import org.apache.commons.io.IOUtils;

public class MetadataDokument
implements MedDokumentEgenskaper {
    private String filnavn;
    private byte[] dokument;
    private String mimeType;

    public MetadataDokument(String filnavn, String mimeType, byte[] dokument) {
        this.filnavn = filnavn;
        this.mimeType = mimeType;
        this.dokument = dokument;
    }

    public static Builder builder(String filnavn, String mimetype, InputStream dokument) {
        Builder builder;
        block8: {
            InputStream dokumentStreamToConsume = dokument;
            try {
                byte[] dokumentBytes = IOUtils.toByteArray((InputStream)dokumentStreamToConsume);
                builder = new Builder(filnavn, mimetype, dokumentBytes);
                if (dokumentStreamToConsume == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dokumentStreamToConsume != null) {
                        try {
                            dokumentStreamToConsume.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new Dokument.LastDokumentException("Kunne ikke lese dokument", e);
                }
            }
            dokumentStreamToConsume.close();
        }
        return builder;
    }

    public static Builder builder(String filnavn, String mimetype, byte[] dokument) {
        return new Builder(filnavn, mimetype, dokument);
    }

    public static Builder builder(String mimetype, File file) {
        try {
            return MetadataDokument.builder(file.getName(), mimetype, new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new Dokument.LastDokumentException("Fant ikke fil", e);
        }
    }

    @Override
    public String getFileName() {
        return this.filnavn;
    }

    @Override
    public byte[] getBytes() {
        return this.dokument;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public static class Builder {
        private final MetadataDokument target;
        private boolean built = false;

        private Builder(String filnavn, String mimetype, byte[] dokument) {
            this.target = new MetadataDokument(filnavn, mimetype, dokument);
        }

        public MetadataDokument build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.target;
        }
    }
}

