/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.domain.digital_post;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import no.difi.sdp.client2.domain.ForretningsMelding;
import no.difi.sdp.client2.domain.ForretningsMeldingType;
import no.difi.sdp.client2.domain.Mottaker;
import no.difi.sdp.client2.domain.digital_post.DigitalPostInfo;
import no.difi.sdp.client2.domain.digital_post.DigitaltVarsel;
import no.difi.sdp.client2.domain.digital_post.EpostVarsel;
import no.difi.sdp.client2.domain.digital_post.Sikkerhetsnivaa;
import no.difi.sdp.client2.domain.digital_post.SmsVarsel;
import no.difi.sdp.client2.domain.digital_post.Spraak;

public class DigitalPost
extends ForretningsMelding {
    private Mottaker mottaker;
    private String tittel;
    private DigitalPostInfo digitalPostInfo = new DigitalPostInfo();
    private Sikkerhetsnivaa sikkerhetsnivaa = Sikkerhetsnivaa.NIVAA_4;
    private DigitaltVarsel varsler = new DigitaltVarsel();
    private Spraak spraak = Spraak.NO;
    private Map<String, String> metadatafiler = new HashMap<String, String>();

    private DigitalPost(Mottaker mottaker, String tittel) {
        super(ForretningsMeldingType.DIGITAL);
        this.mottaker = mottaker;
        this.tittel = tittel;
    }

    @JsonIgnore
    public Mottaker getMottaker() {
        return this.mottaker;
    }

    @JsonIgnore
    public Date getVirkningsdato() {
        return Date.from(this.digitalPostInfo.getVirkningsdato());
    }

    @JsonIgnore
    public boolean isAapningskvittering() {
        return this.digitalPostInfo.isAapningskvittering();
    }

    public DigitalPostInfo getDigitalPostInfo() {
        return this.digitalPostInfo;
    }

    public Sikkerhetsnivaa getSikkerhetsnivaa() {
        return this.sikkerhetsnivaa;
    }

    @JsonIgnore
    @Deprecated
    public EpostVarsel getEpostVarsel() {
        return EpostVarsel.builder(this.varsler.getEpostTekst()).build();
    }

    @JsonIgnore
    @Deprecated
    public SmsVarsel getSmsVarsel() {
        return SmsVarsel.builder(this.varsler.getSmsTekst()).build();
    }

    public void setTittel(String tittel) {
        this.tittel = tittel;
    }

    public String getTittel() {
        return this.tittel;
    }

    @JsonIgnore
    public String getIkkeSensitivTittel() {
        return this.tittel;
    }

    public Spraak getSpraak() {
        return this.spraak;
    }

    public DigitaltVarsel getVarsler() {
        return this.varsler;
    }

    public void addMetadataMapping(String dokumentTittel, String metaDokumentTittel) {
        this.metadatafiler.put(dokumentTittel, metaDokumentTittel);
    }

    public Map<String, String> getMetadataFiler() {
        return this.metadatafiler;
    }

    public static Builder builder(Mottaker mottaker, String tittel) {
        return new Builder(mottaker, tittel);
    }

    public static class Builder {
        private final DigitalPost target;
        private boolean built = false;

        private Builder(Mottaker mottaker, String tittel) {
            this.target = new DigitalPost(mottaker, tittel);
        }

        public Builder virkningsdato(Date virkningsdato) {
            this.target.digitalPostInfo.setVirkningsdato(virkningsdato);
            return this;
        }

        public Builder aapningskvittering(boolean aapningskvittering) {
            this.target.digitalPostInfo.setAapningskvittering(aapningskvittering);
            return this;
        }

        public Builder sikkerhetsnivaa(Sikkerhetsnivaa sikkerhetsnivaa) {
            this.target.sikkerhetsnivaa = sikkerhetsnivaa;
            return this;
        }

        public Builder epostVarsel(EpostVarsel epostVarsel) {
            this.target.varsler.setEpostTekst(epostVarsel.getVarslingsTekst());
            return this;
        }

        public Builder smsVarsel(SmsVarsel smsVarsel) {
            this.target.varsler.setSmsTekst(smsVarsel.getVarslingsTekst());
            return this;
        }

        public DigitalPost build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.target;
        }
    }
}

