/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.domain.fysisk_post;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.difi.sdp.client2.domain.fysisk_post.Landkode;

public class KonvoluttAdresse {
    private Type type;
    private String navn;
    private String adresselinje1;
    private String adresselinje2;
    private String adresselinje3;
    private String adresselinje4;
    private String postnummer;
    private String poststed;
    private String landkode;
    private String land;

    public static Builder build(String mottakersNavn) {
        return new Builder(mottakersNavn);
    }

    @Deprecated
    public boolean er(Type type) {
        return this.type == type;
    }

    @Deprecated
    @JsonIgnore
    public Type getType() {
        return this.type;
    }

    public String getNavn() {
        return this.navn;
    }

    @JsonIgnore
    public List<String> getAdresselinjer() {
        return Stream.of(this.adresselinje1, this.adresselinje2, this.adresselinje3, this.adresselinje4).filter(l -> l != null).collect(Collectors.toList());
    }

    public String getAdresselinje1() {
        return this.adresselinje1;
    }

    public String getAdresselinje2() {
        return this.adresselinje2;
    }

    public String getAdresselinje3() {
        return this.adresselinje3;
    }

    public String getAdresselinje4() {
        return this.adresselinje4;
    }

    public String getLandkode() {
        return this.landkode;
    }

    public String getLand() {
        return this.land;
    }

    public String getPostnummer() {
        return this.postnummer;
    }

    public String getPoststed() {
        return this.poststed;
    }

    public static final class Builder {
        private final KonvoluttAdresse postadresse = new KonvoluttAdresse();
        private boolean built = false;

        private Builder(String mottakersNavn) {
            this.postadresse.navn = mottakersNavn;
        }

        @Deprecated
        public Builder iNorge(String adresselinje1, String adresselinje2, String adresselinje3, String postnummer, String poststed) {
            return this.iNorge(adresselinje1, adresselinje2, adresselinje3, null, postnummer, poststed);
        }

        public Builder iNorge(String adresselinje1, String adresselinje2, String adresselinje3, String adresselinje4, String postnummer, String poststed) {
            this.postadresse.type = Type.NORSK;
            this.postadresse.adresselinje1 = adresselinje1;
            this.postadresse.adresselinje2 = adresselinje2;
            this.postadresse.adresselinje3 = adresselinje3;
            this.postadresse.adresselinje4 = adresselinje4;
            this.postadresse.postnummer = postnummer;
            this.postadresse.poststed = poststed;
            this.postadresse.landkode = "NO";
            this.postadresse.land = "Norway";
            return this;
        }

        public Builder iUtlandet(String adresselinje1, String adresselinje2, String adresselinje3, String adresselinje4, Landkode landkode) {
            return this.iUtlandet(adresselinje1, adresselinje2, adresselinje3, adresselinje4, null, landkode);
        }

        public Builder iUtlandet(String adresselinje1, String adresselinje2, String adresselinje3, String adresselinje4, String land) {
            return this.iUtlandet(adresselinje1, adresselinje2, adresselinje3, adresselinje4, land, null);
        }

        private Builder iUtlandet(String adresselinje1, String adresselinje2, String adresselinje3, String adresselinje4, String land, Landkode landkode) {
            this.postadresse.type = Type.UTENLANDSK;
            this.postadresse.adresselinje1 = adresselinje1;
            this.postadresse.adresselinje2 = adresselinje2;
            this.postadresse.adresselinje3 = adresselinje3;
            this.postadresse.adresselinje4 = adresselinje4;
            this.postadresse.land = land;
            this.postadresse.landkode = landkode != null ? landkode.getKode() : null;
            return this;
        }

        public KonvoluttAdresse build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.postadresse;
        }
    }

    public static enum Type {
        NORSK,
        UTENLANDSK;

    }
}

