/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.domain.sbd;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import no.difi.sdp.client2.domain.ForretningsMelding;
import no.difi.sdp.client2.domain.sbd.CorrelationInformation;
import no.difi.sdp.client2.domain.sbd.MessageInfo;
import no.difi.sdp.client2.domain.sbd.Partner;
import no.difi.sdp.client2.domain.sbd.PartnerIdentification;
import no.difi.sdp.client2.domain.sbd.Scope;
import no.difi.sdp.client2.domain.sbd.ScopeType;
import no.difi.sdp.client2.domain.sbd.StandardBusinessDocumentHeader;

public class StandardBusinessDocument {
    private StandardBusinessDocumentHeader standardBusinessDocumentHeader;
    private Object any;

    @JsonIgnore
    public ForretningsMelding getForretningsMelding() {
        return (ForretningsMelding)this.getAny();
    }

    @JsonIgnore
    public MessageInfo getMessageInfo() {
        return new MessageInfo(this.getMessageType(), this.getReceiverIdentifier(), this.getSenderIdentifier(), this.getConversationId(), this.getDocumentId());
    }

    @JsonIgnore
    public String getSenderIdentifier() {
        return this.getStandardBusinessDocumentHeader().getFirstSender().map(Partner::getIdentifier).map(PartnerIdentification::getStrippedValue).orElse(null);
    }

    @JsonIgnore
    public String getReceiverIdentifier() {
        return this.getStandardBusinessDocumentHeader().getFirstReceiver().map(Partner::getIdentifier).map(PartnerIdentification::getStrippedValue).orElse(null);
    }

    @JsonIgnore
    public String getConversationId() {
        return this.getOptionalConversationId().orElseThrow(RuntimeException::new);
    }

    @JsonIgnore
    public Optional<String> getOptionalConversationId() {
        return this.findScope(ScopeType.CONVERSATION_ID).map(Scope::getInstanceIdentifier);
    }

    @JsonIgnore
    public List<Scope> getScopes() {
        return this.getStandardBusinessDocumentHeader().getBusinessScope().getScope();
    }

    public Scope getScope(ScopeType scopeType) {
        return this.findScope(scopeType).orElseThrow(() -> new RuntimeException(String.format("Missing scope %s", scopeType.name())));
    }

    public Optional<Scope> findScope(ScopeType scopeType) {
        return this.getScopes().stream().filter(scope -> scopeType.toString().equals(scope.getType()) || scopeType.name().equals(scope.getType())).findAny();
    }

    @JsonIgnore
    public String getMessageType() {
        return this.getStandardBusinessDocumentHeader().getDocumentIdentification().getType();
    }

    @JsonIgnore
    public String getStandard() {
        return this.getStandardBusinessDocumentHeader().getDocumentIdentification().getStandard();
    }

    @JsonIgnore
    public String getProcess() {
        return this.getScope(ScopeType.CONVERSATION_ID).getIdentifier();
    }

    @JsonIgnore
    public String getDocumentId() {
        return this.getStandardBusinessDocumentHeader().getDocumentIdentification().getInstanceIdentifier();
    }

    @JsonIgnore
    public String getMessageId() {
        return this.getDocumentId();
    }

    @JsonIgnore
    public Optional<String> getOptionalMessageId() {
        return Optional.ofNullable(this.getDocumentId());
    }

    @JsonIgnore
    public Optional<ZonedDateTime> getExpectedResponseDateTime() {
        return this.getScope(ScopeType.CONVERSATION_ID).getScopeInformation().stream().findFirst().map(CorrelationInformation::getExpectedResponseDateTime);
    }

    public StandardBusinessDocumentHeader getStandardBusinessDocumentHeader() {
        return this.standardBusinessDocumentHeader;
    }

    public Object getAny() {
        return this.any;
    }

    public void setStandardBusinessDocumentHeader(StandardBusinessDocumentHeader standardBusinessDocumentHeader) {
        this.standardBusinessDocumentHeader = standardBusinessDocumentHeader;
    }

    public void setAny(Object any) {
        this.any = any;
    }

    public String toString() {
        return "StandardBusinessDocument(standardBusinessDocumentHeader=" + this.getStandardBusinessDocumentHeader() + ", any=" + this.getAny() + ")";
    }
}

