/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.internal;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import no.difi.sdp.client2.ExceptionMapper;
import no.difi.sdp.client2.KlientKonfigurasjon;
import no.difi.sdp.client2.domain.Dokumentpakke;
import no.difi.sdp.client2.domain.exceptions.SendException;
import no.difi.sdp.client2.domain.sbd.StandardBusinessDocument;
import no.difi.sdp.client2.internal.AddClientVersionInterceptor;
import no.difi.sdp.client2.internal.http.IntegrasjonspunktKvittering;
import no.difi.sdp.client2.internal.http.MessageSender;
import org.apache.http.HttpRequestInterceptor;

public class IntegrasjonspunktMessageSenderFacade {
    private final MessageSender messageSender;
    private ExceptionMapper exceptionMapper = new ExceptionMapper();

    public IntegrasjonspunktMessageSenderFacade(KlientKonfigurasjon klientKonfigurasjon) {
        int connectTimeoutInMillis = (int)klientKonfigurasjon.getConnectTimeoutInMillis();
        int socketTimeoutInMillis = (int)klientKonfigurasjon.getSocketTimeoutInMillis();
        int connectionRequestTimeoutInMillis = (int)klientKonfigurasjon.getConnectionRequestTimeoutInMillis();
        MessageSender.Builder messageSenderBuilder = MessageSender.create(klientKonfigurasjon.getMiljo().getIntegrasjonspunktRoot()).withConnectTimeout(connectTimeoutInMillis).withSocketTimeout(socketTimeoutInMillis).withConnectionRequestTimeout(connectionRequestTimeoutInMillis).withDefaultMaxPerRoute(klientKonfigurasjon.getMaxConnectionPoolSize()).withMaxTotal(klientKonfigurasjon.getMaxConnectionPoolSize());
        if (klientKonfigurasjon.useProxy()) {
            messageSenderBuilder.withHttpProxy(klientKonfigurasjon.getProxyHost(), klientKonfigurasjon.getProxyPort(), klientKonfigurasjon.getProxyScheme());
        }
        HttpRequestInterceptor[] httpRequestInterceptors = Arrays.copyOf(klientKonfigurasjon.getHttpRequestInterceptors(), klientKonfigurasjon.getHttpRequestInterceptors().length + 1);
        httpRequestInterceptors[httpRequestInterceptors.length - 1] = new AddClientVersionInterceptor();
        messageSenderBuilder.withHttpRequestInterceptors(httpRequestInterceptors);
        messageSenderBuilder.withHttpResponseInterceptors(klientKonfigurasjon.getHttpResponseInterceptors());
        this.messageSender = messageSenderBuilder.build();
    }

    public void send(StandardBusinessDocument forsendelse, Dokumentpakke sbdForsendelse) {
        this.performRequest(() -> this.messageSender.send(forsendelse, sbdForsendelse));
    }

    public void bekreft(long id) {
        this.performRequest(() -> this.messageSender.bekreftKvittering(id));
    }

    private void performRequest(Runnable request) {
        this.performRequest(() -> {
            request.run();
            return null;
        });
    }

    private <T> T performRequest(Supplier<T> request) throws SendException {
        try {
            return request.get();
        }
        catch (RuntimeException e) {
            throw this.exceptionMapper.mapException(e);
        }
    }

    public void setExceptionMapper(ExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
    }

    public Optional<IntegrasjonspunktKvittering> hentKvittering() {
        return this.performRequest(this.messageSender::hentKvittering);
    }
}

