/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.internal;

import java.time.Clock;
import java.time.ZonedDateTime;
import no.difi.sdp.client2.domain.Avsender;
import no.difi.sdp.client2.domain.DatabehandlerOrganisasjonsnummer;
import no.difi.sdp.client2.domain.ForretningsMelding;
import no.difi.sdp.client2.domain.Forsendelse;
import no.difi.sdp.client2.domain.digital_post.DigitalPost;
import no.difi.sdp.client2.domain.sbd.Process;
import no.difi.sdp.client2.domain.sbd.StandardBusinessDocument;
import no.difi.sdp.client2.domain.sbd.StandardBusinessDocumentHeader;

public class SBDForsendelseBuilder {
    public static StandardBusinessDocument buildSBD(DatabehandlerOrganisasjonsnummer databehandler, Forsendelse forsendelse) {
        Clock clock = Clock.systemDefaultZone();
        return SBDForsendelseBuilder.buildSBD(databehandler, forsendelse, clock);
    }

    public static StandardBusinessDocument buildSBD(DatabehandlerOrganisasjonsnummer databehandler, Forsendelse forsendelse, Clock clock) {
        ForretningsMelding forretningsMelding = forsendelse.getForretningsMelding();
        forretningsMelding.setHoveddokument(forsendelse.getDokumentpakke().getHoveddokument().getFilnavn());
        Avsender avsender = forsendelse.getAvsender();
        forretningsMelding.setAvsenderId(avsender.getAvsenderIdentifikator());
        forretningsMelding.setFakturaReferanse(avsender.getFakturaReferanse());
        if (forsendelse.type == Forsendelse.Type.DIGITAL) {
            forsendelse.getDokumentpakke().getHoveddokumentOgVedlegg().filter(dokument -> dokument.getMetadataDocument().isPresent()).forEach(dokument -> ((DigitalPost)forretningsMelding).addMetadataMapping(dokument.getFileName(), dokument.getMetadataDocument().get().getFileName()));
        }
        StandardBusinessDocument sbd = new StandardBusinessDocument();
        String konversasjonsId = forsendelse.getKonversasjonsId();
        StandardBusinessDocumentHeader sbdHeader = new StandardBusinessDocumentHeader.Builder().process(Process.DIGITAL_POST_VEDTAK).standard(forsendelse.type).from(databehandler).onBehalfOf(avsender.getOrganisasjonsnummer()).to(forsendelse.getMottaker()).type(forretningsMelding.getType()).relatedToConversationId(konversasjonsId).relatedToMessageId(konversasjonsId).creationDateAndTime(ZonedDateTime.now(clock)).build();
        sbd.setStandardBusinessDocumentHeader(sbdHeader);
        sbd.setAny(forretningsMelding);
        return sbd;
    }
}

