/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.internal;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import no.difi.sdp.client2.domain.exceptions.SertifikatException;
import no.digipost.security.DigipostSecurity;

@Deprecated
public class TrustedCertificates {
    private static Stream<X509Certificate> getTrustedRootCertificates(Environment environment) {
        Stream.Builder<X509Certificate> trustedCertificates = Stream.builder();
        switch (environment) {
            case PRODUCTION: {
                trustedCertificates.add(DigipostSecurity.readCertificate((String)"certificates/prod/BPClass3RootCA.cer"));
                trustedCertificates.add(DigipostSecurity.readCertificate((String)"certificates/prod/commfides_root_ca.cer"));
                break;
            }
            case TEST: {
                trustedCertificates.add(DigipostSecurity.readCertificate((String)"certificates/test/Buypass_Class_3_Test4_Root_CA.cer"));
                trustedCertificates.add(DigipostSecurity.readCertificate((String)"certificates/test/commfides_test_root_ca.cer"));
                break;
            }
            default: {
                throw TrustedCertificates.getInvalidEnvironmentException(environment);
            }
        }
        return trustedCertificates.build();
    }

    private static Stream<X509Certificate> getTrustedIntermediateCertificates(Environment environment) {
        Stream.Builder<X509Certificate> trustedCertificates = Stream.builder();
        switch (environment) {
            case PRODUCTION: {
                trustedCertificates.add(DigipostSecurity.readCertificate((String)"certificates/prod/BPClass3CA3.cer"));
                trustedCertificates.add(DigipostSecurity.readCertificate((String)"certificates/prod/commfides_ca.cer"));
                break;
            }
            case TEST: {
                trustedCertificates.add(DigipostSecurity.readCertificate((String)"certificates/test/Buypass_Class_3_Test4_CA_3.cer"));
                trustedCertificates.add(DigipostSecurity.readCertificate((String)"certificates/test/commfides_test_ca.cer"));
                break;
            }
            default: {
                throw TrustedCertificates.getInvalidEnvironmentException(environment);
            }
        }
        return trustedCertificates.build();
    }

    private static IllegalStateException getInvalidEnvironmentException(Environment environment) {
        String exceptionDescription = MessageFormat.format("The environment {0} is not supported for trusted certificates.", new Object[]{environment});
        return new IllegalStateException(exceptionDescription);
    }

    @Deprecated
    public static KeyStore getTrustStore() {
        KeyStore trustStore;
        try {
            trustStore = KeyStore.getInstance("JCEKS");
            trustStore.load(null, "".toCharArray());
        }
        catch (Exception e) {
            throw new SertifikatException("Oppretting av tom keystore feilet. Grunnen er " + e.toString());
        }
        try {
            TrustedCertificates.addCertificatesToTrustStore(TrustedCertificates.getTrustedRootCertificates(Environment.PRODUCTION), trustStore);
            TrustedCertificates.addCertificatesToTrustStore(TrustedCertificates.getTrustedIntermediateCertificates(Environment.PRODUCTION), trustStore);
            TrustedCertificates.addCertificatesToTrustStore(TrustedCertificates.getTrustedRootCertificates(Environment.TEST), trustStore);
            TrustedCertificates.addCertificatesToTrustStore(TrustedCertificates.getTrustedIntermediateCertificates(Environment.TEST), trustStore);
        }
        catch (KeyStoreException e) {
            throw new SertifikatException("Klarte ikke \u00e5 legge til sertifikat til trust store. Grunnen er " + e.toString());
        }
        return trustStore;
    }

    @Deprecated
    public static void addCertificatesToTrustStore(Stream<X509Certificate> certificates, KeyStore trustStore) throws KeyStoreException {
        for (X509Certificate cert : certificates.collect(Collectors.toList())) {
            String uniqueCertificateAlias = cert.getSerialNumber().toString() + Math.random();
            trustStore.setCertificateEntry(uniqueCertificateAlias, cert);
        }
    }

    static enum Environment {
        PRODUCTION,
        TEST;

    }
}

