/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.internal.http;

import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import no.difi.sdp.client2.domain.Dokumentpakke;
import no.difi.sdp.client2.domain.sbd.StandardBusinessDocument;
import no.difi.sdp.client2.internal.http.IntegrasjonspunktKvittering;
import no.difi.sdp.client2.internal.http.MessageSenderImpl;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MessageSender {
    public static Builder create(URI uri) {
        return new Builder(uri);
    }

    public void send(StandardBusinessDocument var1, Dokumentpakke var2);

    public Optional<IntegrasjonspunktKvittering> hentKvittering();

    public void bekreftKvittering(long var1);

    public static class InsertInterceptor {
        private final Class<?> clazz;
        private final HttpRequestInterceptor interceptor;

        public InsertInterceptor(Class<?> clazz, HttpRequestInterceptor interceptor) {
            this.clazz = clazz;
            this.interceptor = interceptor;
        }
    }

    public static class Builder {
        public static final int DEFAULT_MAX_PER_ROUTE = 10;
        private static final Logger LOG = LoggerFactory.getLogger(Builder.class);
        private final URI endpointUri;
        private final List<InsertInterceptor> interceptorBefore = new ArrayList<InsertInterceptor>();
        private final List<HttpRequestInterceptor> httpRequestInterceptors = new ArrayList<HttpRequestInterceptor>();
        private final List<HttpResponseInterceptor> httpResponseInterceptors = new ArrayList<HttpResponseInterceptor>();
        private int maxTotal = 10;
        private int defaultMaxPerRoute = 10;
        private HttpHost httpHost;
        private int socketTimeout = 30000;
        private int connectTimeout = 10000;
        private int connectionRequestTimeout = 10000;
        private Duration validateAfterInactivity = Duration.of(2L, ChronoUnit.SECONDS);
        private ClientInterceptorWrapper clientInterceptorWrapper = interceptor -> interceptor;

        private Builder(URI uri) {
            this.endpointUri = uri;
        }

        private static void insertInterceptor(List<HttpRequestInterceptor> meldingInterceptors, InsertInterceptor insertInterceptor) {
            for (HttpRequestInterceptor c : meldingInterceptors) {
                if (!insertInterceptor.clazz.isAssignableFrom(c.getClass())) continue;
                meldingInterceptors.add(meldingInterceptors.indexOf(c), insertInterceptor.interceptor);
                return;
            }
            throw new IllegalArgumentException("Could not find interceptor of class " + insertInterceptor.clazz);
        }

        public Builder withMeldingInterceptorBefore(Class<?> clazz, HttpRequestInterceptor interceptor) {
            this.interceptorBefore.add(new InsertInterceptor(clazz, interceptor));
            return this;
        }

        public Builder withValidateAfterInactivity(Duration validateAfterInactivity) {
            this.validateAfterInactivity = validateAfterInactivity;
            return this;
        }

        public Builder withMaxTotal(int maxTotal) {
            this.maxTotal = maxTotal;
            return this;
        }

        public Builder withDefaultMaxPerRoute(int defaultMaxPerRoute) {
            this.defaultMaxPerRoute = defaultMaxPerRoute;
            return this;
        }

        public Builder withSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder withConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder withConnectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public Builder withHttpProxy(String proxyHost, int proxyPort) {
            this.httpHost = new HttpHost(proxyHost, proxyPort, "https");
            return this;
        }

        public Builder withHttpProxy(String proxyHost, int proxyPort, String scheme) {
            this.httpHost = new HttpHost(proxyHost, proxyPort, scheme);
            return this;
        }

        public Builder withHttpRequestInterceptors(HttpRequestInterceptor ... httpRequestInterceptors) {
            this.httpRequestInterceptors.addAll(Arrays.asList(httpRequestInterceptors));
            return this;
        }

        public Builder withHttpResponseInterceptors(HttpResponseInterceptor ... httpResponseInterceptors) {
            this.httpResponseInterceptors.addAll(Arrays.asList(httpResponseInterceptors));
            return this;
        }

        public Builder withClientInterceptorWrapper(ClientInterceptorWrapper clientInterceptorWrapper) {
            this.clientInterceptorWrapper = clientInterceptorWrapper;
            return this;
        }

        public MessageSender build() {
            ArrayList<HttpRequestInterceptor> meldingInterceptors = new ArrayList<HttpRequestInterceptor>();
            for (InsertInterceptor insertInterceptor : this.interceptorBefore) {
                Builder.insertInterceptor(meldingInterceptors, insertInterceptor);
            }
            return new MessageSenderImpl(this.endpointUri, this.getHttpClient());
        }

        private CloseableHttpClient getHttpClient() {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
            connectionManager.setValidateAfterInactivity((int)this.validateAfterInactivity.toMillis());
            connectionManager.setMaxTotal(this.maxTotal);
            connectionManager.setDefaultMaxPerRoute(this.defaultMaxPerRoute);
            RequestConfig.Builder requestConfigBuilder = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).setConnectionRequestTimeout(this.connectionRequestTimeout).setCookieSpec("ignoreCookies");
            if (this.httpHost != null) {
                requestConfigBuilder.setProxy(this.httpHost);
            }
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(this.connectTimeout).build();
            httpClientBuilder.setDefaultSocketConfig(socketConfig);
            for (HttpRequestInterceptor httpRequestInterceptor : this.httpRequestInterceptors) {
                httpClientBuilder.addInterceptorFirst(httpRequestInterceptor);
            }
            for (HttpResponseInterceptor httpResponseInterceptor : this.httpResponseInterceptors) {
                httpClientBuilder.addInterceptorFirst(httpResponseInterceptor);
            }
            return httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfigBuilder.build()).build();
        }
    }

    @FunctionalInterface
    public static interface ClientInterceptorWrapper {
        public HttpRequestInterceptor wrap(HttpRequestInterceptor var1);
    }
}

