/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.internal.http;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.stream.Collectors;
import no.difi.sdp.client2.domain.Dokument;
import no.difi.sdp.client2.domain.Dokumentpakke;
import no.difi.sdp.client2.domain.MedDokumentEgenskaper;
import no.difi.sdp.client2.domain.exceptions.SendException;
import no.difi.sdp.client2.domain.exceptions.SendIOException;
import no.difi.sdp.client2.domain.fysisk_post.FysiskPost;
import no.difi.sdp.client2.domain.fysisk_post.FysiskPostSerializer;
import no.difi.sdp.client2.domain.sbd.StandardBusinessDocument;
import no.difi.sdp.client2.internal.IntegrasjonspunktMessageSerializer;
import no.difi.sdp.client2.internal.http.IntegrasjonspunktKvittering;
import no.difi.sdp.client2.internal.http.MessageSender;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSenderImpl
implements MessageSender {
    private static final Logger LOG = LoggerFactory.getLogger(MessageSenderImpl.class);
    private static final String CREATE_ENDPOINT_PATH = "/api/messages/out";
    private static final String MESSAGE_ENDPOINT_PATH_TEMPLATE = "/api/messages/out/%s";
    private static final String STATUSES_PEEK_PATH = "/api/statuses/peek";
    private static final String STATUSES_CONFIRM_PATH = "/api/statuses/%d";
    private final String endpointUri;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper mapper;

    public MessageSenderImpl(URI endpointUri, CloseableHttpClient httpClient) {
        this.endpointUri = endpointUri.toString().replaceFirst("/$", "");
        this.httpClient = httpClient;
        SimpleModule sbdSerializerModule = new SimpleModule("sbd-serializer");
        sbdSerializerModule.addSerializer(StandardBusinessDocument.class, (JsonSerializer)new IntegrasjonspunktMessageSerializer());
        sbdSerializerModule.addSerializer(FysiskPost.class, (JsonSerializer)new FysiskPostSerializer());
        this.mapper = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)sbdSerializerModule).enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }

    @Override
    public void send(StandardBusinessDocument sbd, Dokumentpakke dokumentpakke) {
        try {
            this.createMessage(sbd);
            String conversationId = sbd.getConversationId();
            for (Dokument dokument : dokumentpakke.getHoveddokumentOgVedlegg().collect(Collectors.toList())) {
                this.addContent(conversationId, dokument);
                if (!dokument.getMetadataDocument().isPresent()) continue;
                this.addContent(conversationId, dokument.getMetadataDocument().get());
            }
            this.closeMessage(sbd);
        }
        catch (IOException e) {
            throw new SendIOException(e);
        }
    }

    private void createMessage(StandardBusinessDocument sbd) throws IOException {
        String json = this.mapper.writeValueAsString((Object)sbd);
        LOG.debug("Generert f\u00f8lgende json, vil n\u00e5 sende til integrasjonspunkt: {} ", (Object)json);
        HttpPost httpPost = new HttpPost(this.endpointUri + CREATE_ENDPOINT_PATH);
        httpPost.setEntity((HttpEntity)new StringEntity(json));
        httpPost.setHeader("content-type", "application/json");
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
        String responseEntity = EntityUtils.toString((HttpEntity)response.getEntity());
        LOG.debug("Response fra integrasjonspunkt: {}", (Object)responseEntity);
        this.handleResponse(response.getStatusLine().getStatusCode(), responseEntity);
        LOG.info("Opprettet melding til integrasjonspunkt. Klar for \u00e5 legge til dokumenter.");
    }

    private void handleResponse(int statusCode, String response) {
        if (statusCode / 100 != 2) {
            String message = String.format("Received none 2xx status code from integrasjonspunkt: %d. Response: \n %s", statusCode, response);
            throw new SendException(message, SendException.AntattSkyldig.fraHttpStatusCode(statusCode), null);
        }
    }

    private void handleResponse(int statusCode) {
        this.handleResponse(statusCode, "");
    }

    private void addContent(String conversationId, MedDokumentEgenskaper dokument) throws IOException {
        String messageEndpointPath = String.format(MESSAGE_ENDPOINT_PATH_TEMPLATE, conversationId);
        HttpPut documentPut = new HttpPut(this.endpointUri + messageEndpointPath);
        documentPut.setEntity((HttpEntity)new ByteArrayEntity(dokument.getBytes()));
        documentPut.setHeader("content-type", dokument.getMimeType());
        String contentDisposition = String.format("attachment; filename=\"%s\"", dokument.getFileName());
        contentDisposition = contentDisposition + dokument.getDokumentTittel().map(tittel -> String.format("; name=\"%s\"", tittel)).orElse("");
        documentPut.setHeader("content-disposition", contentDisposition);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)documentPut);
        this.handleResponse(response.getStatusLine().getStatusCode());
        LOG.info("Lagt til dokument til sending");
    }

    private void closeMessage(StandardBusinessDocument sbd) throws IOException {
        String messageEndpointPath = String.format(MESSAGE_ENDPOINT_PATH_TEMPLATE, sbd.getConversationId());
        HttpPost fileHttpPost = new HttpPost(this.endpointUri + messageEndpointPath);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)fileHttpPost);
        this.handleResponse(response.getStatusLine().getStatusCode());
        LOG.info("Sending til integrasjonspunkt fullf\u00f8rt");
    }

    @Override
    public Optional<IntegrasjonspunktKvittering> hentKvittering() {
        HttpGet httpGet = new HttpGet(this.endpointUri + STATUSES_PEEK_PATH);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            this.handleResponse(statusCode);
            if (statusCode == 204) {
                return Optional.empty();
            }
            String kvitteringJson = EntityUtils.toString((HttpEntity)response.getEntity());
            LOG.info(kvitteringJson);
            IntegrasjonspunktKvittering kvittering = (IntegrasjonspunktKvittering)this.mapper.readerFor(IntegrasjonspunktKvittering.class).readValue(kvitteringJson);
            return Optional.ofNullable(kvittering);
        }
        catch (IOException e) {
            throw new SendIOException(e);
        }
    }

    @Override
    public void bekreftKvittering(long id) {
        String statusPath = this.endpointUri + String.format(STATUSES_CONFIRM_PATH, id);
        HttpDelete httpDelete = new HttpDelete(statusPath);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpDelete);
            this.handleResponse(response.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            throw new SendIOException(e);
        }
    }
}

