/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.internal.kvittering;

import java.util.Objects;
import no.difi.begrep.sdp.schema_v10.SDPFeil;
import no.difi.begrep.sdp.schema_v10.SDPFeiltype;
import no.difi.begrep.sdp.schema_v10.SDPKvittering;
import no.difi.begrep.sdp.schema_v10.SDPVarslingfeilet;
import no.difi.begrep.sdp.schema_v10.SDPVarslingskanal;
import no.difi.sdp.client2.domain.exceptions.SikkerDigitalPostException;
import no.difi.sdp.client2.domain.kvittering.AapningsKvittering;
import no.difi.sdp.client2.domain.kvittering.Feil;
import no.difi.sdp.client2.domain.kvittering.ForretningsKvittering;
import no.difi.sdp.client2.domain.kvittering.KvitteringsInfo;
import no.difi.sdp.client2.domain.kvittering.LeveringsKvittering;
import no.difi.sdp.client2.domain.kvittering.MottaksKvittering;
import no.difi.sdp.client2.domain.kvittering.ReturpostKvittering;
import no.difi.sdp.client2.domain.kvittering.VarslingFeiletKvittering;
import no.difi.sdp.client2.internal.http.IntegrasjonspunktKvittering;
import no.difi.sdp.client2.internal.kvittering.RawKvitteringTransformer;
import no.difi.sdp.client2.internal.kvittering.SimpleSBDMessage;
import no.digipost.api.representations.KanBekreftesSomBehandletKvittering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KvitteringBuilder {
    private RawKvitteringTransformer transformer = new RawKvitteringTransformer();
    private static final Logger LOG = LoggerFactory.getLogger(KvitteringBuilder.class);

    public ForretningsKvittering buildForretningsKvittering(IntegrasjonspunktKvittering integrasjonspunktKvittering) {
        KvitteringsInfo kvitteringsinfo = KvitteringsInfo.builder().konversasjonsId(integrasjonspunktKvittering.getConversationId().toString()).referanseTilMeldingId(integrasjonspunktKvittering.getMessageId().toString()).tidspunkt(integrasjonspunktKvittering.getLastUpdate().toInstant()).integrasjonspunktId(integrasjonspunktKvittering.getId()).build();
        if (integrasjonspunktKvittering.getRawReceipt() != null) {
            LOG.info("Fikk kvittering med XML. {}", (Object)integrasjonspunktKvittering);
            SimpleSBDMessage simpleSBDMessage = this.transformer.transform(integrasjonspunktKvittering.getRawReceipt());
            return this.buildForretningsKvittering(simpleSBDMessage, kvitteringsinfo);
        }
        if (integrasjonspunktKvittering.getStatus().equals((Object)IntegrasjonspunktKvittering.KvitteringStatus.LEVETID_UTLOPT)) {
            return Feil.builder(this.toKanBekreftesSomBehandletKvittering(kvitteringsinfo), kvitteringsinfo, Feil.Feiltype.KLIENT).detaljer("Sjekk integrasjonspunktet for detaljer.").build();
        }
        if (integrasjonspunktKvittering.getStatus().equals((Object)IntegrasjonspunktKvittering.KvitteringStatus.SENDT) || integrasjonspunktKvittering.getStatus().equals((Object)IntegrasjonspunktKvittering.KvitteringStatus.OPPRETTET)) {
            return null;
        }
        if (integrasjonspunktKvittering.getStatus().equals((Object)IntegrasjonspunktKvittering.KvitteringStatus.ANNET)) {
            throw new SikkerDigitalPostException("Kvittering tilbake fra meldingsformidler var verken kvittering eller feil.");
        }
        throw new SikkerDigitalPostException("En uventet feil oppsto ved h\u00e5ndtering av kvittering: " + integrasjonspunktKvittering.toString());
    }

    private ForretningsKvittering buildForretningsKvittering(SimpleSBDMessage simpleSBDMessage, KvitteringsInfo kvitteringsInfo) {
        KanBekreftesSomBehandletKvittering kvittering = this.toKanBekreftesSomBehandletKvittering(kvitteringsInfo);
        if (simpleSBDMessage.erKvittering()) {
            SDPKvittering sdpKvittering = simpleSBDMessage.getKvittering().kvittering;
            if (sdpKvittering.getAapning() != null) {
                return new AapningsKvittering(kvittering, kvitteringsInfo);
            }
            if (sdpKvittering.getMottak() != null) {
                return new MottaksKvittering(kvittering, kvitteringsInfo);
            }
            if (sdpKvittering.getLevering() != null) {
                return new LeveringsKvittering(kvittering, kvitteringsInfo);
            }
            if (sdpKvittering.getVarslingfeilet() != null) {
                return this.varslingFeiletKvittering(sdpKvittering, kvitteringsInfo);
            }
            if (sdpKvittering.getReturpost() != null) {
                return new ReturpostKvittering(kvittering, kvitteringsInfo);
            }
        } else if (simpleSBDMessage.erFeil()) {
            SDPFeil sdpFeil = simpleSBDMessage.getFeil();
            return this.feil(kvittering, sdpFeil, kvitteringsInfo);
        }
        throw new SikkerDigitalPostException("Kvittering tilbake fra meldingsformidler var verken kvittering eller feil.");
    }

    private ForretningsKvittering feil(KanBekreftesSomBehandletKvittering kvittering, SDPFeil feil, KvitteringsInfo kvitteringsInfo) {
        return Feil.builder(kvittering, kvitteringsInfo, this.mapFeilType(feil.getFeiltype())).detaljer(feil.getDetaljer()).build();
    }

    private ForretningsKvittering varslingFeiletKvittering(SDPKvittering sdpKvittering, KvitteringsInfo kvitteringsInfo) {
        SDPVarslingfeilet varslingfeilet = sdpKvittering.getVarslingfeilet();
        VarslingFeiletKvittering.Varslingskanal varslingskanal = this.mapVarslingsKanal(varslingfeilet.getVarslingskanal());
        return VarslingFeiletKvittering.builder(this.toKanBekreftesSomBehandletKvittering(kvitteringsInfo), kvitteringsInfo, varslingskanal).beskrivelse(varslingfeilet.getBeskrivelse()).build();
    }

    private KanBekreftesSomBehandletKvittering toKanBekreftesSomBehandletKvittering(final KvitteringsInfo kvitteringsInfo) {
        return new KanBekreftesSomBehandletKvittering(){

            @Override
            public Long getIntegrasjonspunktId() {
                return kvitteringsInfo.getIntegrasjonspunktId();
            }

            @Override
            public String getMeldingsId() {
                return kvitteringsInfo.getReferanseTilMeldingId();
            }
        };
    }

    private Feil.Feiltype mapFeilType(SDPFeiltype feiltype) {
        Objects.requireNonNull(feiltype);
        if (feiltype == SDPFeiltype.KLIENT) {
            return Feil.Feiltype.KLIENT;
        }
        return Feil.Feiltype.SERVER;
    }

    private VarslingFeiletKvittering.Varslingskanal mapVarslingsKanal(SDPVarslingskanal varslingskanal) {
        Objects.requireNonNull(varslingskanal);
        if (varslingskanal == SDPVarslingskanal.EPOST) {
            return VarslingFeiletKvittering.Varslingskanal.EPOST;
        }
        return VarslingFeiletKvittering.Varslingskanal.SMS;
    }
}

