/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.domain.kvittering;

import java.time.Instant;

public class KvitteringsInfo {
    private String konversasjonsId;
    private String referanseTilMeldingId;
    private Instant tidspunkt;
    private Long integrasjonspunktId;

    public String getKonversasjonsId() {
        return this.konversasjonsId;
    }

    public String getReferanseTilMeldingId() {
        return this.referanseTilMeldingId;
    }

    public Instant getTidspunkt() {
        return this.tidspunkt;
    }

    public Long getIntegrasjonspunktId() {
        return this.integrasjonspunktId;
    }

    protected KvitteringsInfo(String konversasjonsId, String referanseTilMeldingId, Instant tidspunkt, Long integrasjonspunktId) {
        this.konversasjonsId = konversasjonsId;
        this.referanseTilMeldingId = referanseTilMeldingId;
        this.tidspunkt = tidspunkt;
        this.integrasjonspunktId = integrasjonspunktId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean built;
        private String konversasjonsId;
        private String referanseTilMeldingId;
        private Instant tidspunkt;
        private Long integrasjonspunktId;

        private Builder() {
        }

        public Builder konversasjonsId(String konversasjonsId) {
            this.konversasjonsId = konversasjonsId;
            return this;
        }

        public Builder referanseTilMeldingId(String referanseTilMeldingId) {
            this.referanseTilMeldingId = referanseTilMeldingId;
            return this;
        }

        public Builder integrasjonspunktId(Long integrasjonspunktId) {
            this.integrasjonspunktId = integrasjonspunktId;
            return this;
        }

        public Builder tidspunkt(Instant tidspunkt) {
            this.tidspunkt = tidspunkt;
            return this;
        }

        public KvitteringsInfo build() {
            if (this.built) {
                throw new IllegalStateException("Kan ikke bygges flere ganger.");
            }
            if (this.tidspunkt == null || this.konversasjonsId == null || this.referanseTilMeldingId == null) {
                throw new RuntimeException("Alle felter m\u00e5 v\u00e6re initialisert for \u00e5 kunne bygges.");
            }
            this.built = true;
            return new KvitteringsInfo(this.konversasjonsId, this.referanseTilMeldingId, this.tidspunkt, this.integrasjonspunktId);
        }
    }
}

