/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.domain.sbd;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import no.difi.sdp.client2.domain.AvsenderOrganisasjonsnummer;
import no.difi.sdp.client2.domain.DatabehandlerOrganisasjonsnummer;
import no.difi.sdp.client2.domain.Forsendelse;
import no.difi.sdp.client2.domain.Mottaker;
import no.difi.sdp.client2.domain.sbd.BusinessScope;
import no.difi.sdp.client2.domain.sbd.DocumentIdentification;
import no.difi.sdp.client2.domain.sbd.Partner;
import no.difi.sdp.client2.domain.sbd.PartnerIdentification;
import no.difi.sdp.client2.domain.sbd.Process;
import no.difi.sdp.client2.domain.sbd.Receiver;
import no.difi.sdp.client2.domain.sbd.Scope;
import no.difi.sdp.client2.domain.sbd.ScopeType;
import no.difi.sdp.client2.domain.sbd.Sender;
import no.digipost.api.representations.Organisasjonsnummer;

public class StandardBusinessDocumentHeader {
    private String headerVersion;
    private List<Sender> sender;
    private List<Receiver> receiver;
    private DocumentIdentification documentIdentification;
    private BusinessScope businessScope;

    public void setSender(List<Sender> sender) {
        this.sender = sender;
    }

    public List<Sender> getSender() {
        if (this.sender == null) {
            this.sender = new ArrayList<Sender>();
        }
        return this.sender;
    }

    public StandardBusinessDocumentHeader addSender(Sender partner) {
        if (partner != null) {
            this.getSender().add(partner);
        }
        return this;
    }

    public List<Receiver> getReceiver() {
        if (this.receiver == null) {
            this.receiver = new ArrayList<Receiver>();
        }
        return this.receiver;
    }

    public StandardBusinessDocumentHeader addReceiver(Receiver partner) {
        this.getReceiver().add(partner);
        return this;
    }

    @JsonIgnore
    Optional<Sender> getFirstSender() {
        if (this.sender == null) {
            return Optional.empty();
        }
        return this.sender.stream().findFirst();
    }

    @JsonIgnore
    Optional<Receiver> getFirstReceiver() {
        if (this.receiver == null) {
            return Optional.empty();
        }
        return this.receiver.stream().findFirst();
    }

    @JsonIgnore
    public String getReceiverOrganisationNumber() {
        if (this.receiver.size() != 1) {
            throw new RuntimeException(String.valueOf(this.receiver.size()));
        }
        Partner partner = this.receiver.iterator().next();
        PartnerIdentification identifier = partner.getIdentifier();
        if (identifier == null) {
            throw new RuntimeException();
        }
        return identifier.getValue();
    }

    public String getHeaderVersion() {
        return this.headerVersion;
    }

    public DocumentIdentification getDocumentIdentification() {
        return this.documentIdentification;
    }

    public BusinessScope getBusinessScope() {
        return this.businessScope;
    }

    public StandardBusinessDocumentHeader withHeaderVersion(String headerVersion) {
        this.headerVersion = headerVersion;
        return this;
    }

    public void setReceiver(List<Receiver> receiver) {
        this.receiver = receiver;
    }

    public StandardBusinessDocumentHeader setDocumentIdentification(DocumentIdentification documentIdentification) {
        this.documentIdentification = documentIdentification;
        return this;
    }

    public StandardBusinessDocumentHeader setBusinessScope(BusinessScope businessScope) {
        this.businessScope = businessScope;
        return this;
    }

    public String toString() {
        return "StandardBusinessDocumentHeader(headerVersion=" + this.getHeaderVersion() + ", sender=" + this.getSender() + ", receiver=" + this.getReceiver() + ", documentIdentification=" + this.getDocumentIdentification() + ", businessScope=" + this.getBusinessScope() + ")";
    }

    public static class Builder {
        private static final String HEADER_VERSION = "1.0";
        private static final String TYPE_VERSION = "1.0";
        private String mottaker;
        private String sender;
        private String onBehalfOf;
        private String conversationId;
        private String messageId;
        private String documentType;
        private String standard;
        private Process process;
        private ZonedDateTime creationDateAndTime;

        public Builder to(Organisasjonsnummer mottaker) {
            this.mottaker = mottaker.getOrganisasjonsnummerMedLandkode();
            return this;
        }

        public Builder to(Mottaker mottaker) {
            this.mottaker = mottaker.getPersonidentifikator();
            return this;
        }

        public Builder to(String mottaker) {
            this.mottaker = mottaker;
            return this;
        }

        public Builder from(DatabehandlerOrganisasjonsnummer sender) {
            this.sender = sender.getOrganisasjonsnummer();
            return this;
        }

        public Builder onBehalfOf(AvsenderOrganisasjonsnummer onBehalfOf) {
            this.onBehalfOf = onBehalfOf.getOrganisasjonsnummer();
            return this;
        }

        public Builder type(String type) {
            this.documentType = type;
            return this;
        }

        public Builder standard(Forsendelse.Type type) {
            this.standard = type.type;
            return this;
        }

        public Builder process(Process process) {
            this.process = process;
            return this;
        }

        public Builder relatedToConversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public Builder relatedToMessageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder creationDateAndTime(ZonedDateTime creationDateAndTime) {
            this.creationDateAndTime = creationDateAndTime;
            return this;
        }

        public StandardBusinessDocumentHeader build() {
            StandardBusinessDocumentHeader standardBusinessDocumentHeader = new StandardBusinessDocumentHeader().withHeaderVersion("1.0");
            return standardBusinessDocumentHeader.addReceiver(Builder.createReciever(this.mottaker)).addSender(Builder.createSender(this.sender, this.onBehalfOf)).setBusinessScope(Builder.createBusinessScope(this.fromConversationId(this.conversationId))).setDocumentIdentification(Builder.createDocumentIdentification(this.messageId, this.documentType, this.standard, this.creationDateAndTime));
        }

        private static Receiver createReciever(String mottaker) {
            PartnerIdentification identification = new PartnerIdentification();
            identification.setValue(mottaker);
            identification.setAuthority("iso6523-actorid-upis");
            return new Receiver(identification);
        }

        private static Sender createSender(String avsender, String onBehalfOf) {
            PartnerIdentification identification = new PartnerIdentification();
            String value = "0192:" + avsender;
            if (onBehalfOf != null) {
                value = value + ":" + onBehalfOf;
            }
            identification.setValue(value);
            identification.setAuthority("iso6523-actorid-upis");
            return new Sender(identification);
        }

        private static DocumentIdentification createDocumentIdentification(String messageId, String documentType, String standard, ZonedDateTime creationDateAndTime) {
            if (documentType == null) {
                throw new RuntimeException("documentType must be set");
            }
            DocumentIdentification documentIdentification = new DocumentIdentification();
            documentIdentification.setStandard(standard);
            documentIdentification.setType(documentType);
            documentIdentification.setTypeVersion("1.0");
            documentIdentification.setInstanceIdentifier(messageId);
            documentIdentification.setCreationDateAndTime(creationDateAndTime);
            return documentIdentification;
        }

        private static BusinessScope createBusinessScope(Scope ... scopes) {
            BusinessScope businessScope = new BusinessScope();
            businessScope.setScope(new ArrayList<Scope>(Arrays.asList(scopes)));
            return businessScope;
        }

        private Scope fromConversationId(String conversationId) {
            Scope scope = this.createDefaultScope();
            scope.setType(ScopeType.CONVERSATION_ID.toString());
            scope.setInstanceIdentifier(conversationId);
            return scope;
        }

        private Scope createDefaultScope() {
            if (this.process == null) {
                throw new RuntimeException("Process must be set");
            }
            Scope scope = new Scope();
            scope.setIdentifier(this.process.getValue());
            return scope;
        }
    }
}

