/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.internal.kvittering;

import java.util.Arrays;
import no.difi.begrep.sdp.schema_v10.SDPAvsender;
import no.difi.begrep.sdp.schema_v10.SDPDigitalPost;
import no.difi.begrep.sdp.schema_v10.SDPDigitalPostInfo;
import no.difi.begrep.sdp.schema_v10.SDPFeil;
import no.difi.begrep.sdp.schema_v10.SDPFlyttetDigitalPost;
import no.difi.begrep.sdp.schema_v10.SDPFysiskPostInfo;
import no.difi.begrep.sdp.schema_v10.SDPKvittering;
import no.difi.begrep.sdp.schema_v10.SDPMelding;
import no.difi.begrep.sdp.schema_v10.SDPMottaker;
import no.difi.begrep.sdp.schema_v10.SDPVarslingfeilet;
import no.digipost.xsd.types.DigitalPostformidling;

public class SimpleSBDMessage {
    private final Object any;

    public SimpleSBDMessage(Object any) {
        this.any = any;
    }

    public boolean erKvittering() {
        return this.any instanceof SDPKvittering;
    }

    public boolean erDigitalPost() {
        return this.any instanceof SDPDigitalPost;
    }

    public boolean erFlyttetDigitalPost() {
        return this.any instanceof SDPFlyttetDigitalPost;
    }

    public boolean erFeil() {
        return this.any instanceof SDPFeil;
    }

    public Object getUnderlyingDoc() {
        return this.any;
    }

    public SDPFeil getFeil() {
        return (SDPFeil)this.any;
    }

    public SimpleKvittering getKvittering() {
        return new SimpleKvittering((SDPKvittering)this.any);
    }

    public SimpleDigitalPostformidling getDigitalPostformidling() {
        return new SimpleDigitalPostformidling((DigitalPostformidling)this.any);
    }

    public SDPMelding getMelding() {
        return (SDPMelding)this.any;
    }

    public class SimpleKvittering {
        public final SDPKvittering kvittering;

        public SimpleKvittering(SDPKvittering kvittering) {
            this.kvittering = kvittering;
        }

        public boolean erMottak() {
            return this.kvittering.getMottak() != null;
        }

        public boolean erLevertTilPostkasse() {
            return this.kvittering.getLevering() != null;
        }

        public boolean erAapnet() {
            return this.kvittering.getAapning() != null;
        }

        public boolean erVarslingFeilet() {
            return this.kvittering.getVarslingfeilet() != null;
        }

        public boolean erReturpost() {
            return this.kvittering.getReturpost() != null;
        }

        public SDPVarslingfeilet getVarslingFeilet() {
            return this.kvittering.getVarslingfeilet();
        }
    }

    public static class SimpleDigitalPostformidling {
        public final Type type;
        private final DigitalPostformidling digitalPostformidling;

        public SimpleDigitalPostformidling(DigitalPostformidling digitalPostformidling) {
            this.type = Type.of(digitalPostformidling);
            this.digitalPostformidling = digitalPostformidling;
        }

        public SDPDigitalPost getDigitalPost() {
            return (SDPDigitalPost)Type.NY_POST.validateInstance(this.digitalPostformidling);
        }

        public SDPFlyttetDigitalPost getFlyttetDigitalPost() {
            return (SDPFlyttetDigitalPost)Type.FLYTTET.validateInstance(this.digitalPostformidling);
        }

        public boolean kreverAapningsKvittering() {
            SDPDigitalPostInfo postinfo = this.getDigitalPostInfo();
            return postinfo != null ? postinfo.getAapningskvittering() : false;
        }

        public SDPAvsender getAvsender() {
            return this.digitalPostformidling.getAvsender();
        }

        public SDPMottaker getMottaker() {
            return this.digitalPostformidling.getMottaker();
        }

        public SDPDigitalPostInfo getDigitalPostInfo() {
            return this.digitalPostformidling.getDigitalPostInfo();
        }

        public boolean erDigitalPostTilFysiskLevering() {
            return this.digitalPostformidling instanceof SDPDigitalPost && ((SDPDigitalPost)this.digitalPostformidling).getFysiskPostInfo() != null;
        }

        public SDPFysiskPostInfo getFysiskPostInfo() {
            return ((SDPDigitalPost)this.digitalPostformidling).getFysiskPostInfo();
        }

        public boolean erAlleredeAapnet() {
            return this.type == Type.FLYTTET && this.getFlyttetDigitalPost().isAapnet();
        }

        public static enum Type {
            NY_POST(SDPDigitalPost.class),
            FLYTTET(SDPFlyttetDigitalPost.class);

            private final Class<? extends DigitalPostformidling> associatedClass;

            private Type(Class<? extends DigitalPostformidling> associatedClass) {
                this.associatedClass = associatedClass;
            }

            public static Type of(DigitalPostformidling melding) {
                for (Type type : Type.values()) {
                    if (!type.isInstance(melding)) continue;
                    return type;
                }
                throw new IllegalArgumentException(DigitalPostformidling.class.getSimpleName() + " av type " + melding.getClass().getName() + "ble ikke gjenkjent som noen av " + Arrays.toString((Object[])Type.values()));
            }

            public boolean isInstance(DigitalPostformidling melding) {
                return this.associatedClass.isInstance(melding);
            }

            public <T extends DigitalPostformidling> T validateInstance(T candidate) {
                if (this.isInstance(candidate)) {
                    return candidate;
                }
                Type type = Type.of(candidate);
                throw new IllegalArgumentException(candidate.getClass().getName() + " er ikke av forventet type " + (Object)((Object)this) + ", men ble gjenkjent som " + (Object)((Object)type));
            }
        }
    }
}

