/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2;

import java.util.Optional;
import no.difi.sdp.client2.ExceptionMapper;
import no.difi.sdp.client2.KlientKonfigurasjon;
import no.difi.sdp.client2.SendResultat;
import no.difi.sdp.client2.domain.Databehandler;
import no.difi.sdp.client2.domain.Forsendelse;
import no.difi.sdp.client2.domain.exceptions.SendException;
import no.difi.sdp.client2.domain.kvittering.ForretningsKvittering;
import no.difi.sdp.client2.domain.kvittering.KvitteringForespoersel;
import no.difi.sdp.client2.domain.sbd.StandardBusinessDocument;
import no.difi.sdp.client2.internal.IntegrasjonspunktMessageSenderFacade;
import no.difi.sdp.client2.internal.SBDForsendelseBuilder;
import no.difi.sdp.client2.internal.http.IntegrasjonspunktKvittering;
import no.difi.sdp.client2.internal.kvittering.KvitteringBuilder;
import no.digipost.api.representations.KanBekreftesSomBehandletKvittering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SikkerDigitalPostKlient {
    private final Databehandler databehandler;
    private final KvitteringBuilder kvitteringBuilder = new KvitteringBuilder();
    private final IntegrasjonspunktMessageSenderFacade integrasjonspunktMessageSenderFacade;
    private static final Logger LOG = LoggerFactory.getLogger(SikkerDigitalPostKlient.class);

    public SikkerDigitalPostKlient(Databehandler databehandler, KlientKonfigurasjon klientKonfigurasjon) {
        this.integrasjonspunktMessageSenderFacade = new IntegrasjonspunktMessageSenderFacade(klientKonfigurasjon);
        this.databehandler = databehandler;
    }

    public SendResultat send(Forsendelse forsendelse) throws SendException {
        StandardBusinessDocument sbd = SBDForsendelseBuilder.buildSBD(this.databehandler.organisasjonsnummer, forsendelse);
        this.integrasjonspunktMessageSenderFacade.send(sbd, forsendelse.getDokumentpakke());
        return new SendResultat(sbd.getConversationId());
    }

    public ForretningsKvittering hentKvittering() throws SendException {
        return this.hentKvitteringOgBekreftForrige(null, null);
    }

    public ForretningsKvittering hentKvittering(KvitteringForespoersel kvitteringForespoersel) throws SendException {
        return this.hentKvitteringOgBekreftForrige(kvitteringForespoersel, null);
    }

    public ForretningsKvittering hentKvitteringOgBekreftForrige(KanBekreftesSomBehandletKvittering forrigeKvittering) throws SendException {
        return this.hentKvitteringOgBekreftForrige(null, forrigeKvittering);
    }

    public ForretningsKvittering hentKvitteringOgBekreftForrige(KvitteringForespoersel kvitteringForespoersel, KanBekreftesSomBehandletKvittering forrigeKvittering) throws SendException {
        if (forrigeKvittering != null) {
            this.bekreft(forrigeKvittering);
        }
        int guard = 100;
        for (int count = 0; count < guard; ++count) {
            Optional<IntegrasjonspunktKvittering> kvitteringOptional = this.integrasjonspunktMessageSenderFacade.hentKvittering();
            boolean shouldFetchAgain = kvitteringOptional.map(IntegrasjonspunktKvittering::getStatus).filter(status -> status.equals((Object)IntegrasjonspunktKvittering.KvitteringStatus.SENDT) || status.equals((Object)IntegrasjonspunktKvittering.KvitteringStatus.OPPRETTET)).isPresent();
            if (!shouldFetchAgain) {
                return kvitteringOptional.map(this.kvitteringBuilder::buildForretningsKvittering).orElse(null);
            }
            LOG.info("Fikk integrasjonspunktspesifikk statusmelding ved henting av kvittering. Bekreft den og henter neste kvittering fra k\u00f8.");
            this.integrasjonspunktMessageSenderFacade.bekreft(kvitteringOptional.get().getId());
        }
        LOG.warn("Antall fors\u00f8k p\u00e5 \u00e5 hente kvittering overskredet. Det kan komme av det er mange " + (Object)((Object)IntegrasjonspunktKvittering.KvitteringStatus.SENDT) + " og " + (Object)((Object)IntegrasjonspunktKvittering.KvitteringStatus.OPPRETTET) + "-kvitteringer p\u00e5 integrasjonspunktk\u00f8en. Pr\u00f8v igjen.");
        return null;
    }

    public void bekreft(KanBekreftesSomBehandletKvittering forrigeKvittering) throws SendException {
        Long id = forrigeKvittering.getIntegrasjonspunktId();
        if (id != null) {
            this.integrasjonspunktMessageSenderFacade.bekreft(id);
        } else {
            this.integrasjonspunktMessageSenderFacade.hentKvittering().map(IntegrasjonspunktKvittering::getId).ifPresent(this.integrasjonspunktMessageSenderFacade::bekreft);
        }
    }

    public void setExceptionMapper(ExceptionMapper exceptionMapper) {
        this.integrasjonspunktMessageSenderFacade.setExceptionMapper(exceptionMapper);
    }
}

