/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.domain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import no.difi.sdp.client2.domain.MedDokumentEgenskaper;
import no.difi.sdp.client2.domain.MetadataDokument;
import org.apache.commons.io.IOUtils;

public class Dokument
implements MedDokumentEgenskaper {
    private String tittel;
    private String filnavn;
    private byte[] dokument;
    private String mimeType = "application/pdf";
    private MetadataDokument metadataDocument;

    private Dokument(String tittel, String filnavn, byte[] dokument, MetadataDokument metadataDocument) {
        this.tittel = tittel;
        this.filnavn = filnavn;
        this.dokument = dokument;
        this.metadataDocument = metadataDocument;
    }

    @Override
    public String getFileName() {
        return this.getFilnavn();
    }

    @Override
    public byte[] getBytes() {
        return this.dokument;
    }

    public String getFilnavn() {
        return this.filnavn;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public String getTittel() {
        return this.tittel;
    }

    @Override
    public Optional<String> getDokumentTittel() {
        return Optional.ofNullable(this.tittel);
    }

    public Optional<MetadataDokument> getMetadataDocument() {
        return Optional.ofNullable(this.metadataDocument);
    }

    public static Builder builder(String tittel, String filnavn, InputStream dokument) {
        Builder builder;
        block8: {
            InputStream dokumentStreamToConsume = dokument;
            try {
                byte[] dokumentBytes = IOUtils.toByteArray((InputStream)dokumentStreamToConsume);
                builder = new Builder(tittel, filnavn, dokumentBytes);
                if (dokumentStreamToConsume == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dokumentStreamToConsume != null) {
                        try {
                            dokumentStreamToConsume.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new LastDokumentException("Kunne ikke lese dokument", e);
                }
            }
            dokumentStreamToConsume.close();
        }
        return builder;
    }

    public static Builder builder(String tittel, String filnavn, byte[] dokument) {
        return new Builder(tittel, filnavn, dokument);
    }

    public static Builder builder(String tittel, File file) {
        try {
            return Dokument.builder(tittel, file.getName(), new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new LastDokumentException("Fant ikke fil", e);
        }
    }

    public static class LastDokumentException
    extends RuntimeException {
        public LastDokumentException(String message, Exception e) {
            super(message, e);
        }
    }

    public static class Builder {
        private final Dokument target;
        private boolean built = false;

        private Builder(String tittel, String filnavn, byte[] dokument) {
            this.target = new Dokument(tittel, filnavn, dokument, null);
        }

        public Builder mimeType(String mimeType) {
            this.target.mimeType = mimeType;
            return this;
        }

        public Builder metadataDocument(MetadataDokument metadataDokument) {
            this.target.metadataDocument = metadataDokument;
            return this;
        }

        public Dokument build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.target;
        }
    }
}

