/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.domain.fysisk_post;

import java.util.List;
import no.difi.sdp.client2.domain.ForretningsMelding;
import no.difi.sdp.client2.domain.ForretningsMeldingType;
import no.difi.sdp.client2.domain.TekniskMottaker;
import no.difi.sdp.client2.domain.fysisk_post.KonvoluttAdresse;
import no.difi.sdp.client2.domain.fysisk_post.Posttype;
import no.difi.sdp.client2.domain.fysisk_post.Printinstruksjon;
import no.difi.sdp.client2.domain.fysisk_post.Returhaandtering;
import no.difi.sdp.client2.domain.fysisk_post.Utskriftsfarge;

public class FysiskPost
extends ForretningsMelding {
    private KonvoluttAdresse mottaker;
    private Posttype posttype;
    private Utskriftsfarge utskriftsfarge;
    private Returhaandtering returhaandtering;
    private KonvoluttAdresse returadresse;
    private List<Printinstruksjon> printinstruksjoner;

    public FysiskPost() {
        super(ForretningsMeldingType.PRINT);
    }

    @Deprecated
    public KonvoluttAdresse getAdresse() {
        return this.mottaker;
    }

    public KonvoluttAdresse getMottaker() {
        return this.mottaker;
    }

    public Posttype getPosttype() {
        return this.posttype;
    }

    public Utskriftsfarge getUtskriftsfarge() {
        return this.utskriftsfarge;
    }

    public Returhaandtering getReturhaandtering() {
        return this.returhaandtering;
    }

    public KonvoluttAdresse getReturadresse() {
        return this.returadresse;
    }

    @Deprecated
    public TekniskMottaker getUtskriftsleverandoer() {
        return null;
    }

    public List<Printinstruksjon> getPrintinstruksjoner() {
        return this.printinstruksjoner;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final FysiskPost fysiskPost = new FysiskPost();
        private boolean built = false;

        private Builder() {
        }

        public Builder adresse(KonvoluttAdresse adresse) {
            this.fysiskPost.mottaker = adresse;
            return this;
        }

        public Builder sendesMed(Posttype posttype) {
            this.fysiskPost.posttype = posttype;
            return this;
        }

        @Deprecated
        public Builder utskrift(Utskriftsfarge utskriftsfarge, TekniskMottaker utskriftsleverandoer) {
            return this.utskrift(utskriftsfarge);
        }

        public Builder utskrift(Utskriftsfarge utskriftsfarge) {
            this.fysiskPost.utskriftsfarge = utskriftsfarge;
            return this;
        }

        public Builder retur(Returhaandtering haandtering, KonvoluttAdresse returadresse) {
            this.fysiskPost.returhaandtering = haandtering;
            this.fysiskPost.returadresse = returadresse;
            return this;
        }

        public Builder printinstruksjoner(List<Printinstruksjon> printinstruksjoner) {
            this.fysiskPost.printinstruksjoner = printinstruksjoner;
            return this;
        }

        public FysiskPost build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.fysiskPost;
        }
    }
}

