/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client2.domain.sbd;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Objects;
import no.difi.sdp.client2.domain.sbd.Partner;
import no.digipost.api.representations.Organisasjonsnummer;

public class PartnerIdentification
implements Serializable {
    @JsonIgnore
    private Partner partner;
    protected String value;
    protected String authority;

    public PartnerIdentification() {
    }

    public PartnerIdentification(String value, String authority) {
        this.value = value;
        this.authority = authority;
    }

    @JsonIgnore
    String getStrippedValue() {
        if (this.value == null) {
            return null;
        }
        return Organisasjonsnummer.erGyldig(this.value) ? Organisasjonsnummer.of(this.value).toString() : this.value;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public String getValue() {
        return this.value;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartnerIdentification that = (PartnerIdentification)o;
        return Objects.equals(this.partner, that.partner) && Objects.equals(this.value, that.value) && Objects.equals(this.authority, that.authority);
    }

    public int hashCode() {
        return Objects.hash(this.partner, this.value, this.authority);
    }

    public String toString() {
        return "PartnerIdentification(value=" + this.getValue() + ", authority=" + this.getAuthority() + ")";
    }
}

