/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client;

import java.net.URI;
import java.util.concurrent.TimeUnit;
import no.digipost.api.representations.Organisasjonsnummer;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;

public class KlientKonfigurasjon {
    private URI meldingsformidlerRoot = URI.create("https://meldingsformidler.digipost.no/api/ebms");
    private final Organisasjonsnummer meldingsformidlerOrganisasjon = new Organisasjonsnummer("984661185");
    private String proxyHost;
    private int proxyPort;
    private int maxConnectionPoolSize = 10;
    private long socketTimeoutInMillis = TimeUnit.SECONDS.toMillis(30L);
    private long connectTimeoutInMillis = TimeUnit.SECONDS.toMillis(10L);
    private long connectionRequestTimeoutInMillis = TimeUnit.SECONDS.toMillis(10L);
    private ClientInterceptor[] soapInterceptors = new ClientInterceptor[0];
    private HttpRequestInterceptor[] httpRequestInterceptors = new HttpRequestInterceptor[0];
    private HttpResponseInterceptor[] httpResponseInterceptors = new HttpResponseInterceptor[0];

    private KlientKonfigurasjon() {
    }

    public URI getMeldingsformidlerRoot() {
        return this.meldingsformidlerRoot;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public long getSocketTimeoutInMillis() {
        return this.socketTimeoutInMillis;
    }

    public long getConnectTimeoutInMillis() {
        return this.connectTimeoutInMillis;
    }

    public long getConnectionRequestTimeoutInMillis() {
        return this.connectionRequestTimeoutInMillis;
    }

    public int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    public boolean useProxy() {
        return StringUtils.isEmpty((CharSequence)this.proxyHost) && this.proxyPort > 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Organisasjonsnummer getMeldingsformidlerOrganisasjon() {
        return this.meldingsformidlerOrganisasjon;
    }

    public ClientInterceptor[] getSoapInterceptors() {
        return this.soapInterceptors;
    }

    public HttpRequestInterceptor[] getHttpRequestInterceptors() {
        return this.httpRequestInterceptors;
    }

    public HttpResponseInterceptor[] getHttpResponseInterceptors() {
        return this.httpResponseInterceptors;
    }

    static /* synthetic */ ClientInterceptor[] access$902(KlientKonfigurasjon x0, ClientInterceptor[] x1) {
        x0.soapInterceptors = x1;
        return x1;
    }

    static /* synthetic */ HttpRequestInterceptor[] access$1002(KlientKonfigurasjon x0, HttpRequestInterceptor[] x1) {
        x0.httpRequestInterceptors = x1;
        return x1;
    }

    static /* synthetic */ HttpResponseInterceptor[] access$1102(KlientKonfigurasjon x0, HttpResponseInterceptor[] x1) {
        x0.httpResponseInterceptors = x1;
        return x1;
    }

    public static class Builder {
        private final KlientKonfigurasjon target = new KlientKonfigurasjon();

        private Builder() {
        }

        public Builder meldingsformidlerRoot(String meldingsformidlerRoot) {
            this.target.meldingsformidlerRoot = URI.create(meldingsformidlerRoot);
            return this;
        }

        public Builder proxy(String proxyHost, int proxyPort) {
            this.target.proxyHost = proxyHost;
            this.target.proxyPort = proxyPort;
            return this;
        }

        public Builder socketTimeout(int socketTimeout, TimeUnit timeUnit) {
            this.target.socketTimeoutInMillis = timeUnit.toMillis(socketTimeout);
            return this;
        }

        public Builder connectionTimeout(int connectionTimeout, TimeUnit timeUnit) {
            this.target.connectTimeoutInMillis = timeUnit.toMillis(connectionTimeout);
            return this;
        }

        public Builder connectionRequestTimeout(int connectionRequestTimeout, TimeUnit timeUnit) {
            this.target.connectionRequestTimeoutInMillis = timeUnit.toMillis(connectionRequestTimeout);
            return this;
        }

        public Builder maxConnectionPoolSize(int maxConnectionPoolSize) {
            this.target.maxConnectionPoolSize = maxConnectionPoolSize;
            return this;
        }

        public Builder soapInterceptors(ClientInterceptor ... soapInterceptors) {
            KlientKonfigurasjon.access$902(this.target, soapInterceptors);
            return this;
        }

        public Builder httpRequestInterceptors(HttpRequestInterceptor ... httpRequestInterceptors) {
            KlientKonfigurasjon.access$1002(this.target, httpRequestInterceptors);
            return this;
        }

        public Builder httpResponseInterceptors(HttpResponseInterceptor ... httpResponseInterceptors) {
            KlientKonfigurasjon.access$1102(this.target, httpResponseInterceptors);
            return this;
        }

        public KlientKonfigurasjon build() {
            return this.target;
        }
    }
}

