/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client;

import no.difi.sdp.client.ExceptionMapper;
import no.difi.sdp.client.KlientKonfigurasjon;
import no.difi.sdp.client.domain.Forsendelse;
import no.difi.sdp.client.domain.TekniskAvsender;
import no.difi.sdp.client.domain.exceptions.SendException;
import no.difi.sdp.client.domain.kvittering.ForretningsKvittering;
import no.difi.sdp.client.domain.kvittering.KvitteringForespoersel;
import no.difi.sdp.client.internal.DigipostMessageSenderFacade;
import no.difi.sdp.client.internal.EbmsForsendelseBuilder;
import no.difi.sdp.client.internal.KvitteringBuilder;
import no.difi.sdp.client.util.CryptoChecker;
import no.digipost.api.representations.EbmsApplikasjonsKvittering;
import no.digipost.api.representations.EbmsForsendelse;
import no.digipost.api.representations.EbmsPullRequest;

public class SikkerDigitalPostKlient {
    private final TekniskAvsender tekniskAvsender;
    private final EbmsForsendelseBuilder ebmsForsendelseBuilder;
    private final KvitteringBuilder kvitteringBuilder;
    private final DigipostMessageSenderFacade digipostMessageSenderFacade;
    private final KlientKonfigurasjon konfigurasjon;

    public SikkerDigitalPostKlient(TekniskAvsender tekniskAvsender, KlientKonfigurasjon konfigurasjon) {
        CryptoChecker.checkCryptoPolicy();
        this.ebmsForsendelseBuilder = new EbmsForsendelseBuilder();
        this.kvitteringBuilder = new KvitteringBuilder();
        this.digipostMessageSenderFacade = new DigipostMessageSenderFacade(tekniskAvsender, konfigurasjon);
        this.konfigurasjon = konfigurasjon;
        this.tekniskAvsender = tekniskAvsender;
    }

    public void send(Forsendelse forsendelse) throws SendException {
        EbmsForsendelse ebmsForsendelse = this.ebmsForsendelseBuilder.buildEbmsForsendelse(this.tekniskAvsender, this.konfigurasjon.getMeldingsformidlerOrganisasjon(), forsendelse);
        this.digipostMessageSenderFacade.send(ebmsForsendelse);
    }

    public ForretningsKvittering hentKvittering(KvitteringForespoersel kvitteringForespoersel) throws SendException {
        return this.hentKvitteringOgBekreftForrige(kvitteringForespoersel, null);
    }

    public ForretningsKvittering hentKvitteringOgBekreftForrige(KvitteringForespoersel kvitteringForespoersel, ForretningsKvittering forrigeKvittering) throws SendException {
        EbmsPullRequest ebmsPullRequest = this.kvitteringBuilder.buildEbmsPullRequest(this.konfigurasjon.getMeldingsformidlerOrganisasjon(), kvitteringForespoersel);
        EbmsApplikasjonsKvittering applikasjonsKvittering = forrigeKvittering == null ? this.digipostMessageSenderFacade.hentKvittering(ebmsPullRequest) : this.digipostMessageSenderFacade.hentKvittering(ebmsPullRequest, forrigeKvittering.applikasjonsKvittering);
        if (applikasjonsKvittering == null) {
            return null;
        }
        return this.kvitteringBuilder.buildForretningsKvittering(applikasjonsKvittering);
    }

    public void bekreft(ForretningsKvittering forrigeKvittering) throws SendException {
        EbmsApplikasjonsKvittering kvittering = forrigeKvittering.applikasjonsKvittering;
        this.digipostMessageSenderFacade.bekreft(kvittering);
    }

    public void setExceptionMapper(ExceptionMapper exceptionMapper) {
        this.digipostMessageSenderFacade.setExceptionMapper(exceptionMapper);
    }
}

