/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.asice;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import no.difi.sdp.client.asice.ArchivedASiCE;
import no.difi.sdp.client.asice.AsicEAttachable;
import no.difi.sdp.client.asice.archive.Archive;
import no.difi.sdp.client.asice.archive.CreateZip;
import no.difi.sdp.client.asice.manifest.CreateManifest;
import no.difi.sdp.client.asice.manifest.Manifest;
import no.difi.sdp.client.asice.signature.CreateSignature;
import no.difi.sdp.client.asice.signature.Signature;
import no.difi.sdp.client.domain.Forsendelse;
import no.difi.sdp.client.domain.TekniskAvsender;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateASiCE {
    private final CreateManifest createManifest;
    private final CreateSignature createSignature;
    private final CreateZip createZip;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static File debug_writeToDisk = null;

    public CreateASiCE() {
        this.createManifest = new CreateManifest();
        this.createSignature = new CreateSignature();
        this.createZip = new CreateZip();
    }

    public ArchivedASiCE createAsice(TekniskAvsender tekniskAvsender, Forsendelse forsendelse) {
        this.log.info("Creating ASiC-E manifest");
        Manifest manifest = this.createManifest.createManifest(forsendelse);
        ArrayList<AsicEAttachable> files = new ArrayList<AsicEAttachable>();
        files.add(forsendelse.getDokumentpakke().getHoveddokument());
        files.addAll(forsendelse.getDokumentpakke().getVedlegg());
        files.add(manifest);
        this.log.info("Signing ASiC-E documents using private key with alias " + tekniskAvsender.getNoekkelpar().getAlias());
        Signature signature = this.createSignature.createSignature(tekniskAvsender.getNoekkelpar(), files);
        files.add(signature);
        this.log.trace("Zipping ASiC-E files. Contains a total of " + files.size() + " files (including the generated manifest and signatures)");
        Archive archive = this.createZip.zipIt(files);
        if (debug_writeToDisk != null) {
            this.writeArchiveToDisk(archive);
        }
        return new ArchivedASiCE(archive.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeArchiveToDisk(Archive archive) {
        this.log.error("Writing Asic-E to disk for debug");
        File file = debug_writeToDisk.isDirectory() ? new File(debug_writeToDisk, "asic-" + System.currentTimeMillis() + ".zip") : debug_writeToDisk;
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(file);
            IOUtils.copy((InputStream)new ByteArrayInputStream(archive.getBytes()), (OutputStream)output);
            this.log.info("Wrote Asic-E debug file to " + file.getAbsolutePath());
        }
        catch (IOException e) {
            try {
                this.log.error("Could not write Asic-E file", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)output);
        }
        IOUtils.closeQuietly((OutputStream)output);
    }

    @Deprecated
    public static void debug_writeArchiveToDisk(File location) {
        debug_writeToDisk = location;
    }
}

