/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.asice.signature;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import no.difi.sdp.client.asice.AsicEAttachable;
import no.difi.sdp.client.domain.Sertifikat;
import no.difi.sdp.client.domain.exceptions.XmlKonfigurasjonException;
import org.apache.commons.codec.digest.DigestUtils;
import org.etsi.uri._01903.v1_3.CertIDType;
import org.etsi.uri._01903.v1_3.DataObjectFormat;
import org.etsi.uri._01903.v1_3.DigestAlgAndValueType;
import org.etsi.uri._01903.v1_3.QualifyingProperties;
import org.etsi.uri._01903.v1_3.SignedDataObjectProperties;
import org.etsi.uri._01903.v1_3.SignedProperties;
import org.etsi.uri._01903.v1_3.SignedSignatureProperties;
import org.etsi.uri._01903.v1_3.SigningCertificate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.w3.xmldsig.DigestMethod;
import org.w3.xmldsig.X509IssuerSerialType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class CreateXAdESProperties {
    private final DigestMethod sha1DigestMethod = new DigestMethod(Collections.emptyList(), "http://www.w3.org/2000/09/xmldsig#sha1");
    private static Jaxb2Marshaller marshaller = new Jaxb2Marshaller();

    CreateXAdESProperties() {
    }

    public Document createPropertiesToSign(List<AsicEAttachable> files, Sertifikat sertifikat) {
        X509Certificate certificate = sertifikat.getX509Certificate();
        byte[] certificateDigestValue = DigestUtils.sha1((byte[])sertifikat.getEncoded());
        DigestAlgAndValueType certificateDigest = new DigestAlgAndValueType(this.sha1DigestMethod, certificateDigestValue);
        X509IssuerSerialType certificateIssuer = new X509IssuerSerialType(certificate.getIssuerDN().getName(), certificate.getSerialNumber());
        SigningCertificate signingCertificate = new SigningCertificate(Collections.singletonList(new CertIDType(certificateDigest, certificateIssuer, null)));
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        SignedSignatureProperties signedSignatureProperties = new SignedSignatureProperties(now, signingCertificate, null, null, null, null);
        SignedDataObjectProperties signedDataObjectProperties = new SignedDataObjectProperties(this.dataObjectFormats(files), null, null, null, null);
        SignedProperties signedProperties = new SignedProperties(signedSignatureProperties, signedDataObjectProperties, "SignedProperties");
        QualifyingProperties qualifyingProperties = new QualifyingProperties(signedProperties, null, "#Signature", null);
        DOMResult domResult = new DOMResult();
        marshaller.marshal((Object)qualifyingProperties, (Result)domResult);
        Document document = (Document)domResult.getNode();
        this.markAsIdProperty(document, "SignedProperties", "Id");
        return document;
    }

    private List<DataObjectFormat> dataObjectFormats(List<AsicEAttachable> files) {
        ArrayList<DataObjectFormat> dataObjectFormats = new ArrayList<DataObjectFormat>();
        for (AsicEAttachable file : files) {
            dataObjectFormats.add(new DataObjectFormat(null, null, file.getMimeType(), null, "#" + file.getFileName()));
        }
        return dataObjectFormats;
    }

    private void markAsIdProperty(Document document, String elementName, String property) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            Element idElement = (Element)xPath.evaluate("//*[local-name()='" + elementName + "']", document, XPathConstants.NODE);
            idElement.setIdAttribute(property, true);
        }
        catch (XPathExpressionException e) {
            throw new XmlKonfigurasjonException("XPath p\u00e5 generert XML feilet.", e);
        }
    }

    static {
        marshaller.setClassesToBeBound(new Class[]{QualifyingProperties.class});
    }
}

