/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.domain;

import java.util.UUID;
import no.difi.sdp.client.domain.Behandlingsansvarlig;
import no.difi.sdp.client.domain.Dokumentpakke;
import no.difi.sdp.client.domain.Prioritet;
import no.difi.sdp.client.domain.digital_post.DigitalPost;

public class Forsendelse {
    private DigitalPost digitalPost;
    private Dokumentpakke dokumentpakke;
    private Behandlingsansvarlig behandlingsansvarlig;
    private String konversasjonsId = UUID.randomUUID().toString();
    private Prioritet prioritet = Prioritet.NORMAL;
    private String spraakkode = "NO";
    private String mpcId;

    private Forsendelse(Behandlingsansvarlig behandlingsansvarlig, DigitalPost digitalPost, Dokumentpakke dokumentpakke) {
        this.behandlingsansvarlig = behandlingsansvarlig;
        this.digitalPost = digitalPost;
        this.dokumentpakke = dokumentpakke;
    }

    public String getKonversasjonsId() {
        return this.konversasjonsId;
    }

    public DigitalPost getDigitalPost() {
        return this.digitalPost;
    }

    public Dokumentpakke getDokumentpakke() {
        return this.dokumentpakke;
    }

    public Prioritet getPrioritet() {
        return this.prioritet;
    }

    public String getSpraakkode() {
        return this.spraakkode;
    }

    public String getMpcId() {
        return this.mpcId;
    }

    public Behandlingsansvarlig getBehandlingsansvarlig() {
        return this.behandlingsansvarlig;
    }

    public static Builder digital(Behandlingsansvarlig behandlingsansvarlig, DigitalPost digitalPost, Dokumentpakke dokumentpakke) {
        return new Builder(behandlingsansvarlig, digitalPost, dokumentpakke);
    }

    public static class Builder {
        private final Forsendelse target;
        private boolean built = false;

        private Builder(Behandlingsansvarlig behandlingsansvarlig, DigitalPost digitalPost, Dokumentpakke dokumentpakke) {
            this.target = new Forsendelse(behandlingsansvarlig, digitalPost, dokumentpakke);
        }

        public Builder konversasjonsId(String konversasjonsId) {
            this.target.konversasjonsId = konversasjonsId;
            return this;
        }

        public Builder prioritet(Prioritet prioritet) {
            this.target.prioritet = prioritet;
            return this;
        }

        public Builder spraakkode(String spraakkode) {
            this.target.spraakkode = spraakkode;
            return this;
        }

        public Builder mpcId(String mpcId) {
            this.target.mpcId = mpcId;
            return this;
        }

        public Forsendelse build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.target;
        }
    }
}

