/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.domain.exceptions;

import no.difi.sdp.client.domain.exceptions.SendException;
import no.digipost.api.EbmsClientException;

public class EbmsException
extends SendException {
    private final String errorCode;
    private final String errorDescription;

    public EbmsException(EbmsClientException e) {
        super(EbmsException.createMessage(e), SendException.AntattSkyldig.fraSoapFaultCode(e.getSoapError().getFaultCode()), (Exception)e);
        this.errorCode = e.getError().getErrorCode();
        this.errorDescription = e.getError().getDescription().getValue();
    }

    private static String createMessage(EbmsClientException e) {
        String message = "";
        if (e.getError() != null) {
            message = message + e.getError().getErrorCode();
            if (e.getError().getDescription() != null) {
                message = message + " - " + e.getMessage();
            }
            return message;
        }
        return "An unknown ebMS error has occured.";
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }
}

