/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.internal;

import java.util.Arrays;
import no.difi.sdp.client.ExceptionMapper;
import no.difi.sdp.client.KlientKonfigurasjon;
import no.difi.sdp.client.domain.TekniskAvsender;
import no.difi.sdp.client.domain.exceptions.KonfigurasjonException;
import no.difi.sdp.client.domain.exceptions.SendException;
import no.difi.sdp.client.domain.exceptions.XmlValideringException;
import no.difi.sdp.client.internal.AddClientVersionInterceptor;
import no.difi.sdp.client.internal.UserFriendlyWsSecurityExceptionMapper;
import no.digipost.api.MessageSender;
import no.digipost.api.interceptors.KeyStoreInfo;
import no.digipost.api.interceptors.TransactionLogClientInterceptor;
import no.digipost.api.interceptors.WsSecurityInterceptor;
import no.digipost.api.representations.EbmsAktoer;
import no.digipost.api.representations.EbmsApplikasjonsKvittering;
import no.digipost.api.representations.EbmsForsendelse;
import no.digipost.api.representations.EbmsPullRequest;
import no.digipost.api.representations.Organisasjonsnummer;
import no.digipost.api.xml.Schemas;
import org.apache.http.HttpRequestInterceptor;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.client.support.interceptor.PayloadValidatingInterceptor;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointExceptionResolver;
import org.xml.sax.SAXParseException;

public class DigipostMessageSenderFacade {
    private final MessageSender messageSender;
    private ExceptionMapper exceptionMapper = new ExceptionMapper();

    public DigipostMessageSenderFacade(TekniskAvsender avsender, KlientKonfigurasjon konfigurasjon) {
        KeyStoreInfo keyStoreInfo = avsender.getNoekkelpar().getKeyStoreInfo();
        WsSecurityInterceptor wsSecurityInterceptor = new WsSecurityInterceptor(keyStoreInfo, (EndpointExceptionResolver)new UserFriendlyWsSecurityExceptionMapper());
        wsSecurityInterceptor.afterPropertiesSet();
        MessageSender.Builder messageSenderBuilder = MessageSender.create((String)konfigurasjon.getMeldingsformidlerRoot().toString(), (KeyStoreInfo)keyStoreInfo, (WsSecurityInterceptor)wsSecurityInterceptor, (EbmsAktoer)EbmsAktoer.avsender((String)avsender.getOrganisasjonsnummer()), (EbmsAktoer)EbmsAktoer.meldingsformidler((Organisasjonsnummer)konfigurasjon.getMeldingsformidlerOrganisasjon())).withConnectTimeout((int)konfigurasjon.getConnectTimeoutInMillis()).withSocketTimeout((int)konfigurasjon.getSocketTimeoutInMillis()).withConnectionRequestTimeout((int)konfigurasjon.getConnectionRequestTimeoutInMillis()).withDefaultMaxPerRoute(konfigurasjon.getMaxConnectionPoolSize()).withMaxTotal(konfigurasjon.getMaxConnectionPoolSize());
        if (konfigurasjon.useProxy()) {
            messageSenderBuilder.withHttpProxy(konfigurasjon.getProxyHost(), konfigurasjon.getProxyPort());
        }
        HttpRequestInterceptor[] httpRequestInterceptors = Arrays.copyOf(konfigurasjon.getHttpRequestInterceptors(), konfigurasjon.getHttpRequestInterceptors().length + 1);
        httpRequestInterceptors[httpRequestInterceptors.length - 1] = new AddClientVersionInterceptor();
        messageSenderBuilder.withHttpRequestInterceptors(httpRequestInterceptors);
        messageSenderBuilder.withHttpResponseInterceptors(konfigurasjon.getHttpResponseInterceptors());
        messageSenderBuilder.withMeldingInterceptorBefore(TransactionLogClientInterceptor.class, (ClientInterceptor)this.payloadValidatingInterceptor());
        for (ClientInterceptor clientInterceptor : konfigurasjon.getSoapInterceptors()) {
            messageSenderBuilder.withMeldingInterceptorBefore(TransactionLogClientInterceptor.class, clientInterceptor);
        }
        this.messageSender = messageSenderBuilder.build();
    }

    public void send(final EbmsForsendelse ebmsForsendelse) {
        this.performRequest(new VoidRequest(){

            @Override
            public void exec() {
                DigipostMessageSenderFacade.this.messageSender.send(ebmsForsendelse);
            }
        });
    }

    public EbmsApplikasjonsKvittering hentKvittering(final EbmsPullRequest ebmsPullRequest) {
        return this.performRequest(new Request<EbmsApplikasjonsKvittering>(){

            @Override
            public EbmsApplikasjonsKvittering exec() {
                return DigipostMessageSenderFacade.this.messageSender.hentKvittering(ebmsPullRequest);
            }
        });
    }

    public EbmsApplikasjonsKvittering hentKvittering(final EbmsPullRequest ebmsPullRequest, final EbmsApplikasjonsKvittering applikasjonsKvittering) {
        return this.performRequest(new Request<EbmsApplikasjonsKvittering>(){

            @Override
            public EbmsApplikasjonsKvittering exec() {
                return DigipostMessageSenderFacade.this.messageSender.hentKvittering(ebmsPullRequest, applikasjonsKvittering);
            }
        });
    }

    public void bekreft(final EbmsApplikasjonsKvittering kvittering) {
        this.performRequest(new VoidRequest(){

            @Override
            public void exec() {
                DigipostMessageSenderFacade.this.messageSender.bekreft(kvittering);
            }
        });
    }

    private void performRequest(final VoidRequest request) {
        this.performRequest(new Request<Object>(){

            @Override
            public Object exec() {
                request.exec();
                return null;
            }
        });
    }

    private <T> T performRequest(Request<T> request) throws SendException {
        try {
            return request.exec();
        }
        catch (RuntimeException e) {
            SendException mappedException = this.exceptionMapper.mapException(e);
            if (mappedException != null) {
                throw mappedException;
            }
            throw new SendException("An unhandled exception occured while performing request", SendException.AntattSkyldig.UKJENT, e);
        }
    }

    public void setExceptionMapper(ExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
    }

    private PayloadValidatingInterceptor payloadValidatingInterceptor() {
        try {
            PayloadValidatingInterceptor payloadValidatingInterceptor = new PayloadValidatingInterceptor(){

                protected boolean handleRequestValidationErrors(MessageContext messageContext, SAXParseException[] errors) {
                    if (messageContext.hasResponse()) {
                        throw new XmlValideringException("XML validation errors in response from server", errors, SendException.AntattSkyldig.SERVER);
                    }
                    throw new XmlValideringException("XML validation errors in request. Maybe some fields are not being set or are set with null values?", errors, SendException.AntattSkyldig.KLIENT);
                }
            };
            payloadValidatingInterceptor.setSchemas(Schemas.schemaResources());
            payloadValidatingInterceptor.setValidateRequest(true);
            payloadValidatingInterceptor.setValidateResponse(false);
            payloadValidatingInterceptor.afterPropertiesSet();
            return payloadValidatingInterceptor;
        }
        catch (Exception e) {
            throw new KonfigurasjonException("Unable to initialize payload validating interecptor", e);
        }
    }

    private static interface Request<T> {
        public T exec();
    }

    private static interface VoidRequest {
        public void exec();
    }
}

