/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.asice.signature;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import no.difi.sdp.client.asice.AsicEAttachable;
import no.difi.sdp.client.asice.signature.CreateXAdESProperties;
import no.difi.sdp.client.asice.signature.Signature;
import no.difi.sdp.client.domain.Noekkelpar;
import no.difi.sdp.client.domain.exceptions.KonfigurasjonException;
import no.difi.sdp.client.domain.exceptions.RuntimeIOException;
import no.difi.sdp.client.domain.exceptions.SendException;
import no.difi.sdp.client.domain.exceptions.XmlKonfigurasjonException;
import no.difi.sdp.client.domain.exceptions.XmlValideringException;
import no.digipost.api.xml.Schemas;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.core.io.Resource;
import org.springframework.xml.validation.SchemaLoaderUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CreateSignature {
    private final String asicNamespace = "http://uri.etsi.org/2918/v1.2.1#";
    private final String signedPropertiesType = "http://uri.etsi.org/01903#SignedProperties";
    private final DigestMethod sha256DigestMethod;
    private final CanonicalizationMethod canonicalizationMethod;
    private final SignatureMethod signatureMethod;
    private final Transform canonicalXmlTransform;
    private final CreateXAdESProperties createXAdESProperties = new CreateXAdESProperties();
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private final Schema schema;

    public CreateSignature() {
        try {
            XMLSignatureFactory xmlSignatureFactory = this.getSignatureFactory();
            this.sha256DigestMethod = xmlSignatureFactory.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
            this.canonicalizationMethod = xmlSignatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null);
            this.signatureMethod = xmlSignatureFactory.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null);
            this.canonicalXmlTransform = xmlSignatureFactory.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (TransformParameterSpec)null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KonfigurasjonException("Kunne ikke initialisere xml-signering", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new KonfigurasjonException("Kunne ikke initialisere xml-signering", e);
        }
        try {
            this.schema = SchemaLoaderUtils.loadSchema((Resource[])new Resource[]{Schemas.ASICE_SCHEMA}, (String)"http://www.w3.org/2001/XMLSchema");
        }
        catch (IOException e) {
            throw new KonfigurasjonException("Kunne ikke laste schema for validering av signatures", e);
        }
        catch (SAXException e) {
            throw new KonfigurasjonException("Kunne ikke laste schema for validering av signatures", e);
        }
    }

    public Signature createSignature(Noekkelpar noekkelpar, List<AsicEAttachable> attachedFiles) throws XmlValideringException {
        ByteArrayOutputStream outputStream;
        XMLSignatureFactory xmlSignatureFactory = this.getSignatureFactory();
        List<Reference> references = this.references(xmlSignatureFactory, attachedFiles);
        references.add(xmlSignatureFactory.newReference("#SignedProperties", this.sha256DigestMethod, Collections.singletonList(this.canonicalXmlTransform), "http://uri.etsi.org/01903#SignedProperties", null));
        Document document = this.createXAdESProperties.createPropertiesToSign(attachedFiles, noekkelpar.getSertifikat());
        KeyInfo keyInfo = this.keyInfo(xmlSignatureFactory, noekkelpar.getCertificateChain());
        SignedInfo signedInfo = xmlSignatureFactory.newSignedInfo(this.canonicalizationMethod, this.signatureMethod, references);
        XMLObject xmlObject = xmlSignatureFactory.newXMLObject(Collections.singletonList(new DOMStructure(document.getDocumentElement())), null, null, null);
        XMLSignature xmlSignature = xmlSignatureFactory.newXMLSignature(signedInfo, keyInfo, Collections.singletonList(xmlObject), "Signature", null);
        try {
            xmlSignature.sign(new DOMSignContext(noekkelpar.getPrivateKey(), (Node)document));
        }
        catch (MarshalException e) {
            throw new XmlKonfigurasjonException("Klarte ikke \u00e5 lese ASiC-E XML for signering", e);
        }
        catch (XMLSignatureException e) {
            throw new XmlKonfigurasjonException("Klarte ikke \u00e5 signere ASiC-E element.", e);
        }
        this.wrapSignatureInXADeSEnvelope(document);
        try {
            outputStream = new ByteArrayOutputStream();
            Transformer transformer = this.transformerFactory.newTransformer();
            this.schema.newValidator().validate(new DOMSource(document));
            transformer.transform(new DOMSource(document), new StreamResult(outputStream));
        }
        catch (TransformerException e) {
            throw new KonfigurasjonException("Klarte ikke \u00e5 serialisere XML", e);
        }
        catch (SAXException e) {
            throw new XmlValideringException("Kunne ikke validere generert signatures.xml. Sjekk at input er gyldig og at det ikke er ugyldige tegn i filnavn o.l.", SendException.AntattSkyldig.KLIENT, e);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        return new Signature(outputStream.toByteArray());
    }

    private List<Reference> references(XMLSignatureFactory xmlSignatureFactory, List<AsicEAttachable> files) {
        ArrayList<Reference> result = new ArrayList<Reference>();
        for (int i = 0; i < files.size(); ++i) {
            String signatureElementId = String.format("ID_%s", i);
            Reference reference = xmlSignatureFactory.newReference(files.get(i).getFileName(), this.sha256DigestMethod, null, null, signatureElementId, DigestUtils.sha256((byte[])files.get(i).getBytes()));
            result.add(reference);
        }
        return result;
    }

    private KeyInfo keyInfo(XMLSignatureFactory xmlSignatureFactory, Certificate[] sertifikater) {
        KeyInfoFactory keyInfoFactory = xmlSignatureFactory.getKeyInfoFactory();
        X509Data x509Data = keyInfoFactory.newX509Data(Arrays.asList(sertifikater));
        return keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
    }

    private void wrapSignatureInXADeSEnvelope(Document document) {
        Node signatureElement = document.removeChild(document.getDocumentElement());
        Element xadesElement = document.createElementNS("http://uri.etsi.org/2918/v1.2.1#", "XAdESSignatures");
        xadesElement.appendChild(signatureElement);
        document.appendChild(xadesElement);
    }

    private XMLSignatureFactory getSignatureFactory() {
        try {
            return XMLSignatureFactory.getInstance("DOM", "XMLDSig");
        }
        catch (NoSuchProviderException e) {
            throw new KonfigurasjonException("Fant ikke XML Digital Signature-provider. Biblioteket avhenger av default Java-provider.");
        }
    }
}

