/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.domain.kvittering;

import java.util.Date;
import no.difi.sdp.client.domain.kvittering.ForretningsKvittering;
import no.digipost.api.representations.EbmsApplikasjonsKvittering;
import org.joda.time.DateTime;

public class VarslingFeiletKvittering
extends ForretningsKvittering {
    private Varslingskanal varslingskanal;
    private String beskrivelse;

    private VarslingFeiletKvittering(EbmsApplikasjonsKvittering applikasjonsKvittering, Varslingskanal varslingskanal) {
        super(applikasjonsKvittering);
        this.varslingskanal = varslingskanal;
    }

    @Override
    public Date getTidspunkt() {
        DateTime tidspunkt = this.applikasjonsKvittering.getStandardBusinessDocument().getKvittering().kvittering.getTidspunkt();
        return tidspunkt != null ? tidspunkt.toDate() : null;
    }

    public Varslingskanal getVarslingskanal() {
        return this.varslingskanal;
    }

    public String getBeskrivelse() {
        return this.beskrivelse;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "konversasjonsId=" + this.getKonversasjonsId() + ", varslingskanal=" + (Object)((Object)this.varslingskanal) + ", beskrivelse='" + this.beskrivelse + '\'' + '}';
    }

    public static Builder builder(EbmsApplikasjonsKvittering applikasjonsKvittering, Varslingskanal varslingskanal) {
        return new Builder(applikasjonsKvittering, varslingskanal);
    }

    public static enum Varslingskanal {
        SMS,
        EPOST;

    }

    public static class Builder {
        private VarslingFeiletKvittering target;
        private boolean built = false;

        public Builder(EbmsApplikasjonsKvittering applikasjonsKvittering, Varslingskanal varslingskanal) {
            this.target = new VarslingFeiletKvittering(applikasjonsKvittering, varslingskanal);
        }

        public Builder beskrivelse(String beskrivelse) {
            this.target.beskrivelse = beskrivelse;
            return this;
        }

        public VarslingFeiletKvittering build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.target;
        }
    }
}

