/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.internal;

import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import no.difi.sdp.client.domain.Sertifikat;
import no.difi.sdp.client.domain.exceptions.KonfigurasjonException;
import no.difi.sdp.client.domain.exceptions.RuntimeIOException;
import no.difi.sdp.client.internal.CMSDocument;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSAESOAEPparams;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OutputEncryptor;

public class CreateCMSDocument {
    private final ASN1ObjectIdentifier cmsEncryptionAlgorithm;
    private final AlgorithmIdentifier keyEncryptionScheme;

    public CreateCMSDocument() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.keyEncryptionScheme = this.rsaesOaepIdentifier();
        this.cmsEncryptionAlgorithm = CMSAlgorithm.AES256_CBC;
    }

    private AlgorithmIdentifier rsaesOaepIdentifier() {
        AlgorithmIdentifier hash = new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256, (ASN1Encodable)DERNull.INSTANCE);
        AlgorithmIdentifier mask = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)hash);
        AlgorithmIdentifier p_source = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_pSpecified, (ASN1Encodable)new DEROctetString(new byte[0]));
        RSAESOAEPparams parameters = new RSAESOAEPparams(hash, mask, p_source);
        return new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSAES_OAEP, (ASN1Encodable)parameters);
    }

    public CMSDocument createCMS(byte[] bytes, Sertifikat sertifikat) {
        try {
            JceKeyTransRecipientInfoGenerator recipientInfoGenerator = new JceKeyTransRecipientInfoGenerator(sertifikat.getX509Certificate(), this.keyEncryptionScheme).setProvider("BC");
            CMSEnvelopedDataGenerator envelopedDataGenerator = new CMSEnvelopedDataGenerator();
            envelopedDataGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)recipientInfoGenerator);
            OutputEncryptor contentEncryptor = new JceCMSContentEncryptorBuilder(this.cmsEncryptionAlgorithm).build();
            CMSEnvelopedData cmsData = envelopedDataGenerator.generate((CMSTypedData)new CMSProcessableByteArray(bytes), contentEncryptor);
            return new CMSDocument(cmsData.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new KonfigurasjonException("Feil med mottakers sertifikat", e);
        }
        catch (CMSException e) {
            throw new KonfigurasjonException("Kunne ikke generere Cryptographic Message Syntax for dokumentpakke", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

