/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.internal;

import no.difi.sdp.client.asice.ArchivedASiCE;
import no.difi.sdp.client.asice.CreateASiCE;
import no.difi.sdp.client.domain.Forsendelse;
import no.difi.sdp.client.domain.Sertifikat;
import no.difi.sdp.client.domain.TekniskAvsender;
import no.difi.sdp.client.internal.CMSDocument;
import no.difi.sdp.client.internal.CreateCMSDocument;
import no.digipost.api.representations.Dokumentpakke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDokumentpakke {
    private final CreateASiCE createASiCE;
    private final CreateCMSDocument createCMS;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public CreateDokumentpakke() {
        this.createASiCE = new CreateASiCE();
        this.createCMS = new CreateCMSDocument();
    }

    public Dokumentpakke createDokumentpakke(TekniskAvsender tekniskAvsender, Forsendelse forsendelse) {
        this.log.info("Creating dokumentpakke");
        ArchivedASiCE archivedASiCE = this.createASiCE.createAsice(tekniskAvsender, forsendelse);
        Sertifikat mottakerSertifikat = forsendelse.getDigitalPost().getMottaker().getSertifikat();
        this.log.info("Creating CMS document");
        CMSDocument cms = this.createCMS.createCMS(archivedASiCE.getBytes(), mottakerSertifikat);
        return new Dokumentpakke(cms.getBytes());
    }
}

