/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.internal;

import java.util.UUID;
import no.difi.begrep.sdp.schema_v10.SDPDigitalPost;
import no.difi.begrep.sdp.schema_v10.SDPMelding;
import no.difi.sdp.client.domain.Forsendelse;
import no.difi.sdp.client.domain.Mottaker;
import no.difi.sdp.client.domain.TekniskAvsender;
import no.difi.sdp.client.internal.CreateDokumentpakke;
import no.difi.sdp.client.internal.SDPBuilder;
import no.digipost.api.representations.Dokumentpakke;
import no.digipost.api.representations.EbmsAktoer;
import no.digipost.api.representations.EbmsForsendelse;
import no.digipost.api.representations.Organisasjonsnummer;
import no.digipost.api.representations.StandardBusinessDocumentFactory;
import org.unece.cefact.namespaces.standardbusinessdocumentheader.StandardBusinessDocument;

public class EbmsForsendelseBuilder {
    private final SDPBuilder sdpBuilder = new SDPBuilder();
    private final CreateDokumentpakke createDokumentpakke = new CreateDokumentpakke();

    public EbmsForsendelse buildEbmsForsendelse(TekniskAvsender tekniskAvsender, Organisasjonsnummer meldingsformidler, Forsendelse forsendelse) {
        Mottaker mottaker = forsendelse.getDigitalPost().getMottaker();
        EbmsAktoer ebmsAvsender = EbmsAktoer.avsender((String)tekniskAvsender.getOrganisasjonsnummer());
        EbmsAktoer ebmsMottaker = EbmsAktoer.meldingsformidler((Organisasjonsnummer)meldingsformidler);
        String meldingsId = UUID.randomUUID().toString();
        Organisasjonsnummer sbdhMottaker = new Organisasjonsnummer(mottaker.getOrganisasjonsnummerPostkasse());
        Organisasjonsnummer sbdhAvsender = new Organisasjonsnummer(tekniskAvsender.getOrganisasjonsnummer());
        SDPDigitalPost sikkerDigitalPost = this.sdpBuilder.buildDigitalPost(forsendelse);
        StandardBusinessDocument standardBusinessDocument = StandardBusinessDocumentFactory.create((Organisasjonsnummer)sbdhAvsender, (Organisasjonsnummer)sbdhMottaker, (String)meldingsId, (String)forsendelse.getKonversasjonsId(), (SDPMelding)sikkerDigitalPost);
        Dokumentpakke dokumentpakke = this.createDokumentpakke.createDokumentpakke(tekniskAvsender, forsendelse);
        return EbmsForsendelse.create((EbmsAktoer)ebmsAvsender, (EbmsAktoer)ebmsMottaker, (Organisasjonsnummer)sbdhMottaker, (StandardBusinessDocument)standardBusinessDocument, (Dokumentpakke)dokumentpakke).withPrioritet(forsendelse.getPrioritet().getEbmsPrioritet()).withMpcId(forsendelse.getMpcId()).build();
    }
}

