/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.asice.manifest;

import java.io.ByteArrayOutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import no.difi.begrep.sdp.schema_v10.SDPManifest;
import no.difi.sdp.client.asice.manifest.Manifest;
import no.difi.sdp.client.domain.Forsendelse;
import no.difi.sdp.client.domain.exceptions.KonfigurasjonException;
import no.difi.sdp.client.domain.exceptions.SendException;
import no.difi.sdp.client.domain.exceptions.XmlValideringException;
import no.difi.sdp.client.internal.SDPBuilder;
import no.digipost.api.xml.Schemas;
import org.springframework.core.io.Resource;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.xml.sax.SAXParseException;

public class CreateManifest {
    private static final Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
    private final SDPBuilder sdpBuilder = new SDPBuilder();

    public Manifest createManifest(Forsendelse forsendelse) {
        SDPManifest sdpManifest = this.sdpBuilder.createManifest(forsendelse);
        ByteArrayOutputStream manifestStream = new ByteArrayOutputStream();
        try {
            marshaller.marshal((Object)sdpManifest, (Result)new StreamResult(manifestStream));
            return new Manifest(manifestStream.toByteArray());
        }
        catch (MarshallingFailureException e) {
            if (e.getMostSpecificCause() instanceof SAXParseException) {
                throw new XmlValideringException("Kunne ikke validere generert Manifest XML. Sjekk at alle p\u00e5krevde input er satt og ikke er null", SendException.AntattSkyldig.KLIENT, (SAXParseException)e.getMostSpecificCause());
            }
            throw e;
        }
    }

    static {
        marshaller.setClassesToBeBound(new Class[]{SDPManifest.class});
        marshaller.setSchema((Resource)Schemas.SDP_MANIFEST_SCHEMA);
        try {
            marshaller.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new KonfigurasjonException("Kunne ikke sette opp Jaxb marshaller", e);
        }
    }
}

