/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.domain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import no.difi.sdp.client.asice.AsicEAttachable;
import org.apache.commons.io.IOUtils;

public class Dokument
implements AsicEAttachable {
    private String tittel;
    private String filnavn;
    private byte[] dokument;
    private String mimeType = "application/pdf";

    private Dokument(String tittel, String filnavn, InputStream dokumentStream) {
        this.tittel = tittel;
        this.filnavn = filnavn;
        try {
            this.dokument = IOUtils.toByteArray((InputStream)dokumentStream);
        }
        catch (IOException e) {
            throw new LastDokumentException("Kunne ikke lese dokument", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)dokumentStream);
        }
    }

    @Override
    public String getFileName() {
        return this.getFilnavn();
    }

    @Override
    public byte[] getBytes() {
        return this.dokument;
    }

    public String getFilnavn() {
        return this.filnavn;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    public String getTittel() {
        return this.tittel;
    }

    public static Builder builder(String tittel, String filnavn, InputStream dokument) {
        return new Builder(tittel, filnavn, dokument);
    }

    public static Builder builder(String tittel, File file) {
        try {
            return new Builder(tittel, file.getName(), new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new LastDokumentException("Fant ikke fil", e);
        }
    }

    public static class LastDokumentException
    extends RuntimeException {
        public LastDokumentException(String message, Exception e) {
            super(message, e);
        }
    }

    public static class Builder {
        private final Dokument target;
        private boolean built = false;

        private Builder(String tittel, String filnavn, InputStream dokument) {
            this.target = new Dokument(tittel, filnavn, dokument);
        }

        public Builder mimeType(String mimeType) {
            this.target.mimeType = mimeType;
            return this;
        }

        public Dokument build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.target;
        }
    }
}

