/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import no.difi.sdp.client.domain.Dokument;

public class Dokumentpakke {
    private Dokument hoveddokument;
    private List<Dokument> vedlegg = Collections.emptyList();

    private Dokumentpakke(Dokument hoveddokument) {
        this.hoveddokument = hoveddokument;
    }

    public Dokument getHoveddokument() {
        return this.hoveddokument;
    }

    public List<Dokument> getVedlegg() {
        return this.vedlegg;
    }

    public static Builder builder(Dokument hoveddokument) {
        return new Builder(hoveddokument);
    }

    public static class Builder {
        private final Dokumentpakke target;
        private boolean built = false;

        private Builder(Dokument hoveddokument) {
            this.target = new Dokumentpakke(hoveddokument);
        }

        public Builder vedlegg(List<Dokument> vedlegg) {
            this.target.vedlegg = new ArrayList<Dokument>(vedlegg);
            return this;
        }

        public Builder vedlegg(Dokument ... vedlegg) {
            return this.vedlegg(Arrays.asList(vedlegg));
        }

        public Dokumentpakke build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.target;
        }
    }
}

