/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.domain.digital_post;

import java.util.Date;
import no.difi.sdp.client.domain.Mottaker;
import no.difi.sdp.client.domain.digital_post.EpostVarsel;
import no.difi.sdp.client.domain.digital_post.Sikkerhetsnivaa;
import no.difi.sdp.client.domain.digital_post.SmsVarsel;

public class DigitalPost {
    private Mottaker mottaker;
    private Date virkningsdato;
    private boolean aapningskvittering;
    private Sikkerhetsnivaa sikkerhetsnivaa = Sikkerhetsnivaa.NIVAA_4;
    private String ikkeSensitivTittel;
    private EpostVarsel epostVarsel;
    private SmsVarsel smsVarsel;

    private DigitalPost(Mottaker mottaker, String ikkeSensitivTittel) {
        this.mottaker = mottaker;
        this.ikkeSensitivTittel = ikkeSensitivTittel;
    }

    public Mottaker getMottaker() {
        return this.mottaker;
    }

    public Date getVirkningsdato() {
        return this.virkningsdato;
    }

    public boolean isAapningskvittering() {
        return this.aapningskvittering;
    }

    public Sikkerhetsnivaa getSikkerhetsnivaa() {
        return this.sikkerhetsnivaa;
    }

    public String getIkkeSensitivTittel() {
        return this.ikkeSensitivTittel;
    }

    public EpostVarsel getEpostVarsel() {
        return this.epostVarsel;
    }

    public SmsVarsel getSmsVarsel() {
        return this.smsVarsel;
    }

    public static Builder builder(Mottaker mottaker, String ikkeSensitivTittel) {
        return new Builder(mottaker, ikkeSensitivTittel);
    }

    public static class Builder {
        private final DigitalPost target;
        private boolean built = false;

        private Builder(Mottaker mottaker, String ikkeSensitivTittel) {
            this.target = new DigitalPost(mottaker, ikkeSensitivTittel);
        }

        public Builder virkningsdato(Date virkningsdato) {
            this.target.virkningsdato = virkningsdato;
            return this;
        }

        public Builder aapningskvittering(boolean aapningskvittering) {
            this.target.aapningskvittering = aapningskvittering;
            return this;
        }

        public Builder sikkerhetsnivaa(Sikkerhetsnivaa sikkerhetsnivaa) {
            this.target.sikkerhetsnivaa = sikkerhetsnivaa;
            return this;
        }

        public Builder epostVarsel(EpostVarsel epostVarsel) {
            this.target.epostVarsel = epostVarsel;
            return this;
        }

        public Builder smsVarsel(SmsVarsel smsVarsel) {
            this.target.smsVarsel = smsVarsel;
            return this;
        }

        public DigitalPost build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.target;
        }
    }
}

