/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.domain.kvittering;

import java.util.Date;
import no.difi.sdp.client.domain.kvittering.ForretningsKvittering;
import no.digipost.api.representations.EbmsApplikasjonsKvittering;
import org.joda.time.DateTime;

public class Feil
extends ForretningsKvittering {
    private Feiltype feiltype;
    private String detaljer;

    private Feil(EbmsApplikasjonsKvittering applikasjonsKvittering, Feiltype feiltype) {
        super(applikasjonsKvittering);
        this.feiltype = feiltype;
    }

    @Override
    public Date getTidspunkt() {
        DateTime tidspunkt = this.applikasjonsKvittering.getStandardBusinessDocument().getFeil().getTidspunkt();
        return tidspunkt != null ? tidspunkt.toDate() : null;
    }

    public Feiltype getFeiltype() {
        return this.feiltype;
    }

    public String getDetaljer() {
        return this.detaljer;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "konversasjonsId=" + this.getKonversasjonsId() + ", feiltype=" + (Object)((Object)this.feiltype) + ", detaljer='" + this.detaljer + '\'' + '}';
    }

    public static Builder builder(EbmsApplikasjonsKvittering applikasjonsKvittering, Feiltype feiltype) {
        return new Builder(applikasjonsKvittering, feiltype);
    }

    public static enum Feiltype {
        KLIENT,
        SERVER;

    }

    public static class Builder {
        private Feil target;
        private boolean built = false;

        public Builder(EbmsApplikasjonsKvittering applikasjonsKvittering, Feiltype feiltype) {
            this.target = new Feil(applikasjonsKvittering, feiltype);
        }

        public Builder detaljer(String detaljer) {
            this.target.detaljer = detaljer;
            return this;
        }

        public Feil build() {
            if (this.built) {
                throw new IllegalStateException("Can't build twice");
            }
            this.built = true;
            return this.target;
        }
    }
}

