/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.util;

import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import no.difi.sdp.client.domain.exceptions.KonfigurasjonException;

public class CryptoChecker {
    public static final String TRANSFORM_TO_CHECK = "AES";
    public static final int MINIMUM_SUPPORTED_KEY_LENGTH = 256;

    public static void checkCryptoPolicy() {
        try {
            int maxAesKeyLength = Cipher.getMaxAllowedKeyLength(TRANSFORM_TO_CHECK);
            if (maxAesKeyLength < 256) {
                throw new KonfigurasjonException("Minimum st\u00f8ttet n\u00f8kkellengde p\u00e5 platformen er for kort. Det skyldes sannsynligvis at du m\u00e5 legge inn JCE Unlimited Strength JAR. Merk at dette m\u00e5tte gj\u00f8res b\u00e5de for produksjons- og utviklingsmilj\u00f8er.\nMaks st\u00f8ttet lengde er " + maxAesKeyLength + ", mens minimumskravet er " + 256 + " for " + TRANSFORM_TO_CHECK + ".\n" + "For mer informasjon, se https://www.google.no/search?q=java+cryptography+extension+unlimited+strength");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new KonfigurasjonException("Klarte ikke \u00e5 sjekke maks n\u00f8kkellengde for AES");
        }
    }
}

