/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.asice.archive;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import no.difi.sdp.client.asice.AsicEAttachable;
import no.difi.sdp.client.asice.archive.Archive;
import no.difi.sdp.client.domain.exceptions.RuntimeIOException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.Charsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateZip {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public Archive zipIt(List<AsicEAttachable> files) {
        Archive i$;
        ByteArrayOutputStream archive = null;
        ZipArchiveOutputStream zipOutputStream = null;
        try {
            archive = new ByteArrayOutputStream();
            zipOutputStream = new ZipArchiveOutputStream((OutputStream)archive);
            zipOutputStream.setEncoding(Charsets.UTF_8.name());
            zipOutputStream.setMethod(8);
            for (AsicEAttachable file : files) {
                this.log.trace("Adding " + file.getFileName() + " to archive. Size in bytes before compression: " + file.getBytes().length);
                ZipArchiveEntry zipEntry = new ZipArchiveEntry(file.getFileName());
                zipEntry.setSize((long)file.getBytes().length);
                zipOutputStream.putArchiveEntry((ArchiveEntry)zipEntry);
                IOUtils.copy((InputStream)new ByteArrayInputStream(file.getBytes()), (OutputStream)zipOutputStream);
                zipOutputStream.closeArchiveEntry();
            }
            zipOutputStream.finish();
            zipOutputStream.close();
            i$ = new Archive(archive.toByteArray());
        }
        catch (IOException e) {
            try {
                throw new RuntimeIOException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((OutputStream)archive);
                IOUtils.closeQuietly(zipOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)archive);
        IOUtils.closeQuietly((OutputStream)zipOutputStream);
        return i$;
    }
}

