/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.domain;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import no.difi.sdp.client.domain.Sertifikat;
import no.difi.sdp.client.domain.exceptions.NoekkelException;
import no.digipost.api.interceptors.KeyStoreInfo;

public class Noekkelpar {
    private KeyStore keyStore;
    private String alias;
    private String password;

    private Noekkelpar(KeyStore keyStore, String alias, String password) {
        this.keyStore = keyStore;
        this.alias = alias;
        this.password = password;
    }

    public String getAlias() {
        return this.alias;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public KeyStoreInfo getKeyStoreInfo() {
        return new KeyStoreInfo(this.keyStore, this.alias, this.password);
    }

    public Sertifikat getSertifikat() {
        return Sertifikat.fraKeyStore(this.keyStore, this.alias);
    }

    public Certificate[] getCertificateChain() {
        try {
            return this.keyStore.getCertificateChain(this.alias);
        }
        catch (KeyStoreException e) {
            throw new NoekkelException("Kunne ikke hente privat n\u00f8kkel fra KeyStore. Er KeyStore initialisiert?", e);
        }
    }

    public PrivateKey getPrivateKey() {
        try {
            Key key = this.keyStore.getKey(this.alias, this.password.toCharArray());
            if (!(key instanceof PrivateKey)) {
                throw new NoekkelException("Kunne ikke hente privat n\u00f8kkel fra key store. Forventet \u00e5 f\u00e5 en PrivateKey, fikk " + key.getClass().getCanonicalName());
            }
            return (PrivateKey)key;
        }
        catch (KeyStoreException e) {
            throw new NoekkelException("Kunne ikke hente privat n\u00f8kkel fra KeyStore. Er KeyStore initialisiert?", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoekkelException("Kunne ikke hente privat n\u00f8kkel fra KeyStore. Verifiser at n\u00f8kkelen er st\u00f8ttet p\u00e5 plattformen", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new NoekkelException("Kunne ikke hente privat n\u00f8kkel fra KeyStore. Sjekk at passordet er riktig.", e);
        }
    }

    public static Noekkelpar fraKeyStore(KeyStore keyStore, String alias, String password) {
        return new Noekkelpar(keyStore, alias, password);
    }
}

