/*
 * Decompiled with CFR 0.152.
 */
package no.difi.sdp.client.internal;

import java.util.ArrayList;
import no.difi.begrep.sdp.schema_v10.SDPAvsender;
import no.difi.begrep.sdp.schema_v10.SDPDigitalPost;
import no.difi.begrep.sdp.schema_v10.SDPDigitalPostInfo;
import no.difi.begrep.sdp.schema_v10.SDPDokument;
import no.difi.begrep.sdp.schema_v10.SDPEpostVarsel;
import no.difi.begrep.sdp.schema_v10.SDPEpostVarselTekst;
import no.difi.begrep.sdp.schema_v10.SDPFysiskPostInfo;
import no.difi.begrep.sdp.schema_v10.SDPIso6523Authority;
import no.difi.begrep.sdp.schema_v10.SDPManifest;
import no.difi.begrep.sdp.schema_v10.SDPMottaker;
import no.difi.begrep.sdp.schema_v10.SDPOrganisasjon;
import no.difi.begrep.sdp.schema_v10.SDPPerson;
import no.difi.begrep.sdp.schema_v10.SDPRepetisjoner;
import no.difi.begrep.sdp.schema_v10.SDPSikkerhetsnivaa;
import no.difi.begrep.sdp.schema_v10.SDPSmsVarsel;
import no.difi.begrep.sdp.schema_v10.SDPSmsVarselTekst;
import no.difi.begrep.sdp.schema_v10.SDPTittel;
import no.difi.begrep.sdp.schema_v10.SDPVarsler;
import no.difi.begrep.sdp.schema_v10.SDPVirksomhet;
import no.difi.sdp.client.domain.Behandlingsansvarlig;
import no.difi.sdp.client.domain.Dokument;
import no.difi.sdp.client.domain.Forsendelse;
import no.difi.sdp.client.domain.Mottaker;
import no.difi.sdp.client.domain.digital_post.DigitalPost;
import no.difi.sdp.client.domain.digital_post.EpostVarsel;
import no.difi.sdp.client.domain.digital_post.SmsVarsel;
import org.joda.time.LocalDate;
import org.w3.xmldsig.Reference;
import org.w3.xmldsig.Signature;

public class SDPBuilder {
    private static final String ORGNR_IDENTIFIER = "9908:";

    public SDPManifest createManifest(Forsendelse forsendelse) {
        Mottaker mottaker = forsendelse.getDigitalPost().getMottaker();
        SDPMottaker sdpMottaker = this.sdpMottaker(mottaker);
        SDPAvsender sdpAvsender = this.sdpAvsender(forsendelse.getBehandlingsansvarlig());
        String spraakkode = forsendelse.getSpraakkode();
        SDPDokument sdpHovedDokument = this.sdpDokument(forsendelse.getDokumentpakke().getHoveddokument(), spraakkode);
        ArrayList<SDPDokument> sdpVedlegg = new ArrayList<SDPDokument>();
        for (Dokument dokument : forsendelse.getDokumentpakke().getVedlegg()) {
            sdpVedlegg.add(this.sdpDokument(dokument, spraakkode));
        }
        return new SDPManifest(sdpMottaker, sdpAvsender, sdpHovedDokument, sdpVedlegg);
    }

    public SDPDigitalPost buildDigitalPost(Forsendelse forsendelse) {
        SDPAvsender sdpAvsender = this.sdpAvsender(forsendelse.getBehandlingsansvarlig());
        SDPMottaker sdpMottaker = this.sdpMottaker(forsendelse.getDigitalPost().getMottaker());
        SDPDigitalPostInfo sdpDigitalPostInfo = this.sdpDigitalPostinfo(forsendelse);
        Signature signature = null;
        Reference dokumentpakkefingeravtrykk = null;
        SDPFysiskPostInfo fysiskPostInfo = null;
        return new SDPDigitalPost(signature, sdpAvsender, sdpMottaker, sdpDigitalPostInfo, fysiskPostInfo, dokumentpakkefingeravtrykk);
    }

    private SDPDokument sdpDokument(Dokument dokument, String spraakkode) {
        SDPTittel sdpTittel = new SDPTittel(dokument.getTittel(), spraakkode);
        return new SDPDokument(sdpTittel, dokument.getFilnavn(), dokument.getMimeType());
    }

    private SDPMottaker sdpMottaker(Mottaker mottaker) {
        SDPVirksomhet virksomhet = null;
        SDPPerson sdpPerson = new SDPPerson(mottaker.getPersonidentifikator(), mottaker.getPostkasseadresse());
        return new SDPMottaker(virksomhet, sdpPerson);
    }

    private SDPAvsender sdpAvsender(Behandlingsansvarlig avsender) {
        String fakturaReferanse = avsender.getFakturaReferanse();
        String identifikator = avsender.getAvsenderIdentifikator();
        SDPOrganisasjon organisasjon = this.sdpOrganisasjon(avsender);
        return new SDPAvsender(organisasjon, identifikator, fakturaReferanse);
    }

    private SDPOrganisasjon sdpOrganisasjon(Behandlingsansvarlig avsender) {
        return new SDPOrganisasjon(ORGNR_IDENTIFIER + avsender.getOrganisasjonsnummer(), SDPIso6523Authority.ISO_6523_ACTORID_UPIS);
    }

    private SDPDigitalPostInfo sdpDigitalPostinfo(Forsendelse forsendelse) {
        DigitalPost digitalPost = forsendelse.getDigitalPost();
        LocalDate virkningsdato = null;
        if (digitalPost.getVirkningsdato() != null) {
            virkningsdato = new LocalDate((Object)digitalPost.getVirkningsdato());
        }
        boolean aapningskvittering = digitalPost.isAapningskvittering();
        SDPSikkerhetsnivaa sikkerhetsnivaa = digitalPost.getSikkerhetsnivaa().getXmlValue();
        SDPTittel tittel = new SDPTittel(digitalPost.getIkkeSensitivTittel(), forsendelse.getSpraakkode());
        SDPVarsler varsler = this.sdpVarsler(forsendelse);
        return new SDPDigitalPostInfo(virkningsdato, Boolean.valueOf(aapningskvittering), sikkerhetsnivaa, tittel, varsler);
    }

    private SDPVarsler sdpVarsler(Forsendelse forsendelse) {
        String spraakkode = forsendelse.getSpraakkode();
        SDPEpostVarsel epostVarsel = this.sdpEpostVarsel(forsendelse.getDigitalPost().getEpostVarsel(), spraakkode);
        SDPSmsVarsel smsVarsel = this.sdpSmsVarsel(forsendelse.getDigitalPost().getSmsVarsel(), spraakkode);
        return new SDPVarsler(epostVarsel, smsVarsel);
    }

    private SDPSmsVarsel sdpSmsVarsel(SmsVarsel smsVarsel, String spraakkode) {
        if (smsVarsel != null) {
            SDPSmsVarselTekst smsVarselTekst = new SDPSmsVarselTekst(smsVarsel.getVarslingsTekst(), spraakkode);
            return new SDPSmsVarsel(smsVarsel.getMobilnummer(), smsVarselTekst, new SDPRepetisjoner(smsVarsel.getDagerEtter()));
        }
        return null;
    }

    private SDPEpostVarsel sdpEpostVarsel(EpostVarsel epostVarsel, String spraakkode) {
        if (epostVarsel != null) {
            SDPEpostVarselTekst epostVarselTekst = new SDPEpostVarselTekst(epostVarsel.getVarslingsTekst(), spraakkode);
            return new SDPEpostVarsel(epostVarsel.getEpostadresse(), epostVarselTekst, new SDPRepetisjoner(epostVarsel.getDagerEtter()));
        }
        return null;
    }
}

