/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security;

import java.security.cert.X509Certificate;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import no.digipost.security.IllegalCertificateType;
import no.digipost.security.NotSecure;

public class Https {
    public static final String REQUEST_CLIENT_CERTIFICATE_ATTRIBUTE = "javax.servlet.request.X509Certificate";

    public static X509Certificate extractClientCertificate(ServletRequest request) {
        if (!request.isSecure()) {
            String resourceDescription;
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                resourceDescription = httpRequest.getMethod() + ": " + httpRequest.getRequestURI();
            } else {
                resourceDescription = request.toString();
            }
            throw new NotSecure(ServletRequest.class, resourceDescription);
        }
        Object certObj = request.getAttribute(REQUEST_CLIENT_CERTIFICATE_ATTRIBUTE);
        if (certObj instanceof Object[] && ((Object[])certObj).length > 0) {
            certObj = ((Object[])certObj)[0];
        }
        if (certObj instanceof X509Certificate) {
            return (X509Certificate)certObj;
        }
        throw new IllegalCertificateType(certObj);
    }

    private Https() {
    }
}

