/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.cert;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import no.digipost.security.cert.CertStatus;
import no.digipost.security.cert.OcspPolicy;
import no.digipost.security.cert.OcspSignatureValidator;

public class CertificateValidatorConfig {
    public static final CertificateValidatorConfig MOST_STRICT = new CertificateValidatorConfig(OcspPolicy.ALWAYS_DO_OCSP_LOOKUP, EnumSet.of(CertStatus.OK), OcspSignatureValidator.DEFAULT, false);
    final OcspPolicy ocspPolicy;
    private final Set<CertStatus> allowedOcspResults;
    final OcspSignatureValidator ocspSignatureValidator;
    final boolean ignoreCustomSigningCertificatesInOcspResponses;

    public boolean allowsOcspResult(CertStatus status) {
        return this.allowedOcspResults.contains((Object)status);
    }

    private CertificateValidatorConfig(OcspPolicy ocspPolicy, Set<CertStatus> allowedOcspResults, OcspSignatureValidator ocspSignatureValidator, boolean ignoreCustomSigningCertificatesInOcspResponses) {
        this.ocspPolicy = ocspPolicy;
        this.allowedOcspResults = Collections.unmodifiableSet(allowedOcspResults);
        this.ocspSignatureValidator = ocspSignatureValidator;
        this.ignoreCustomSigningCertificatesInOcspResponses = ignoreCustomSigningCertificatesInOcspResponses;
    }

    public CertificateValidatorConfig withOcspPolicy(OcspPolicy ocspPolicy) {
        return new CertificateValidatorConfig(ocspPolicy, this.allowedOcspResults, this.ocspSignatureValidator, this.ignoreCustomSigningCertificatesInOcspResponses);
    }

    public CertificateValidatorConfig allowOcspResults(CertStatus ... allowedOcspResults) {
        return new CertificateValidatorConfig(this.ocspPolicy, EnumSet.of(CertStatus.OK, allowedOcspResults), this.ocspSignatureValidator, this.ignoreCustomSigningCertificatesInOcspResponses);
    }

    CertificateValidatorConfig validateOcspResponseSignatureUsing(OcspSignatureValidator ocspSignatureValidator) {
        return new CertificateValidatorConfig(this.ocspPolicy, this.allowedOcspResults, ocspSignatureValidator, this.ignoreCustomSigningCertificatesInOcspResponses);
    }

    CertificateValidatorConfig ignoreCustomSigningCertificatesInOcspResponses() {
        return new CertificateValidatorConfig(this.ocspPolicy, this.allowedOcspResults, this.ocspSignatureValidator, true);
    }
}

