/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.cert;

import java.security.cert.X509Certificate;
import java.util.List;
import java.util.stream.Collectors;
import no.digipost.security.DigipostSecurity;
import no.digipost.security.DigipostSecurityException;

public class MissingTrustAnchorException
extends DigipostSecurityException {
    private final List<X509Certificate> certificates;

    public MissingTrustAnchorException(List<X509Certificate> certificates) {
        super(certificates.size() + " certificates missing trust anchor certificates: " + certificates.stream().map(DigipostSecurity::describe).collect(Collectors.joining(", ")));
        this.certificates = certificates;
    }

    public List<X509Certificate> getCertificates() {
        return this.certificates;
    }
}

