/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.cert;

import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.function.Predicate;
import no.digipost.security.DigipostSecurity;
import no.digipost.security.DigipostSecurityException;
import no.digipost.security.InvalidState;
import no.digipost.security.cert.TrustedCertificateAndIssuer;
import no.digipost.security.cert.Untrusted;

public final class ReviewedCertPath {
    private final Optional<CertPath> path;
    private final Predicate<CertPath> isTrusted;
    public final Optional<GeneralSecurityException> exception;

    ReviewedCertPath(CertPath path, Predicate<CertPath> trusted) {
        this(Optional.of(path), trusted, Optional.empty());
    }

    ReviewedCertPath(GeneralSecurityException exception) {
        this(Optional.empty(), p -> false, Optional.of(exception));
    }

    private ReviewedCertPath(Optional<CertPath> path, Predicate<CertPath> trusted, Optional<GeneralSecurityException> exception) {
        this.path = path;
        this.isTrusted = trusted;
        this.exception = exception;
    }

    public CertPath getPath() {
        return this.path.orElseThrow(() -> this.exception.map(DigipostSecurityException::new).orElseGet(() -> new DigipostSecurityException("no certpath or exception")));
    }

    public boolean isTrusted() {
        return this.path.filter(this.isTrusted).isPresent();
    }

    public CertPath getTrustedPath() {
        CertPath certpath = this.getPath();
        if (this.isTrusted()) {
            return certpath;
        }
        throw new Untrusted(certpath, (Throwable)this.exception.orElse(null));
    }

    public TrustedCertificateAndIssuer getTrustedCertificateAndIssuer() {
        CertPath trustedCertPath = this.getTrustedPath();
        X509Certificate certificate = DigipostSecurity.asStream(trustedCertPath).findFirst().orElseThrow(() -> new InvalidState("No certificate found at all in supposedly trusted CertPath!", trustedCertPath));
        X509Certificate issuer = DigipostSecurity.asStream(trustedCertPath).skip(1L).findFirst().orElseThrow(() -> new InvalidState("No issuer found for supposedly trusted certificate", certificate));
        return new TrustedCertificateAndIssuer(certificate, issuer);
    }

    public String toString() {
        return (this.isTrusted() ? "Trusted: " : "Untrusted: ") + this.path.map(DigipostSecurity::describe).orElse(this.exception.map(e -> e.getClass().getSimpleName() + ": '" + e.getMessage() + "'").orElse("No certpath or exception"));
    }
}

