/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.cert;

import java.time.Clock;
import no.digipost.security.cert.ProdEnvCertificates;
import no.digipost.security.cert.TestEnvCertificates;
import no.digipost.security.cert.Trust;

public final class TrustFactory {
    public final Seid1 seid1 = new Seid1();
    public final Seid2 seid2 = new Seid2();
    public final Digipost digipost = new Digipost();
    private final Clock clock;

    public TrustFactory(Clock clock) {
        this.clock = clock;
    }

    public final class Digipost {
        public Trust digipostIssuedCertificates() {
            return Trust.from(TrustFactory.this.clock, ProdEnvCertificates.digipostRootCa());
        }

        public Trust digipostIssuedTestCertificates() {
            return Trust.from(TrustFactory.this.clock, TestEnvCertificates.digipostTestRootCa());
        }

        private Digipost() {
        }
    }

    public final class Seid1 {
        public Trust buypassAndCommfidesEnterpriseCertificates() {
            return Trust.merge(this.buypassEnterpriseCertificates(), this.commfidesEnterpriseCertificates());
        }

        public Trust buypassAndCommfidesTestEnterpriseCertificates() {
            return Trust.merge(this.buypassTestEnterpriseCertificates(), this.commfidesTestEnterpriseCertificates());
        }

        public Trust buypassEnterpriseCertificates() {
            return Trust.from(TrustFactory.this.clock, ProdEnvCertificates.buypassClass3RootCa(), ProdEnvCertificates.buypassClass3Ca3());
        }

        public Trust buypassTestEnterpriseCertificates() {
            return Trust.from(TrustFactory.this.clock, TestEnvCertificates.buypassClass3Test4RootCa(), TestEnvCertificates.buypassClass3Test4Ca3());
        }

        public Trust commfidesEnterpriseCertificates() {
            return Trust.from(TrustFactory.this.clock, ProdEnvCertificates.commfidesRootCa(), ProdEnvCertificates.commfidesCa());
        }

        public Trust commfidesTestEnterpriseCertificates() {
            return Trust.from(TrustFactory.this.clock, TestEnvCertificates.commfidesTestRootCa(), TestEnvCertificates.commfidesTestCa());
        }

        private Seid1() {
        }
    }

    public final class Seid2 {
        public Trust buypassEnterpriseCertificates() {
            return Trust.from(TrustFactory.this.clock, ProdEnvCertificates.buypassClass3RootCaG2SoftToken(), ProdEnvCertificates.buypassClass3CaG2SoftToken(), ProdEnvCertificates.buypassClass3RootCaG2HardToken(), ProdEnvCertificates.buypassClass3CaG2HardToken());
        }

        public Trust buypassTestEnterpriseCertificates() {
            return Trust.from(TrustFactory.this.clock, TestEnvCertificates.buypassClass3TestRootCaG2SoftToken(), TestEnvCertificates.buypassClass3TestCaG2SoftToken(), TestEnvCertificates.buypassClass3TestRootCaG2HardToken(), TestEnvCertificates.buypassClass3TestCaG2HardToken());
        }

        private Seid2() {
        }
    }
}

