/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.cert;

import java.security.cert.X509Certificate;
import java.util.Optional;
import no.digipost.security.DigipostSecurity;
import no.digipost.security.cert.CertHelper;
import no.digipost.security.ocsp.OcspLookupRequest;

public final class TrustedCertificateAndIssuer {
    public final X509Certificate certificate;
    public final X509Certificate issuer;
    public final Optional<OcspLookupRequest> ocspLookupRequest;

    TrustedCertificateAndIssuer(X509Certificate trustedCertificate, X509Certificate trustedIssuer) {
        this.certificate = trustedCertificate;
        this.issuer = trustedIssuer;
        this.ocspLookupRequest = OcspLookupRequest.tryCreate(trustedCertificate, trustedIssuer);
    }

    boolean isIssuedByDigipostCA() {
        return CertHelper.getOrganizationUnits(this.issuer).anyMatch("Digipost"::equals);
    }

    public String toString() {
        return "Trusted certificate: " + DigipostSecurity.describe(this.certificate) + ", issued by " + DigipostSecurity.describe(this.issuer) + ", " + this.ocspLookupRequest.map(request -> "OCSP-lookup may be done at " + request.url).orElse("OCSP-lookup is not possible");
    }
}

