/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.crl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import no.digipost.security.DigipostSecurity;
import org.apache.http.ssl.TrustStrategy;

public class RevocationChecker
implements TrustStrategy {
    private final CRL crl;

    public RevocationChecker(Path crlPath) {
        CertificateFactory cf = DigipostSecurity.getX509CertificateFactory();
        try (InputStream inputStream = Files.newInputStream(crlPath, new OpenOption[0]);){
            this.crl = cf.generateCRL(inputStream);
        }
        catch (IOException | CRLException e) {
            throw new RuntimeException(String.format("Could not load CRL from path '%s'.", crlPath));
        }
    }

    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        for (X509Certificate certificate : chain) {
            if (!this.crl.isRevoked(certificate)) continue;
            throw new CertificateException(String.format("Certificate with serial number %s is revoked: %s", certificate.getSerialNumber().toString(16), DigipostSecurity.describe(certificate)));
        }
        return false;
    }
}

