/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.keystore;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import no.digipost.security.DigipostSecurityException;
import no.digipost.security.keystore.DuplicateAlias;
import no.digipost.security.keystore.KeyStoreType;

public final class KeyStoreBuilder {
    public static final Function<? super X509Certificate, String> DEFAULT_ALIAS_CREATOR = cert -> cert.getSubjectX500Principal().getName() + "-" + cert.getSerialNumber() + "-" + cert.getIssuerX500Principal().getName();
    private final KeyStoreType type;
    private final Map<String, X509Certificate> certificates;
    private String keyStoreClasspathResourceName;
    private InputStream keyStoreStream;

    public KeyStoreBuilder(KeyStoreType type) {
        this.type = type;
        this.certificates = new LinkedHashMap<String, X509Certificate>();
    }

    public KeyStoreBuilder containing(X509Certificate certificate) {
        return this.containing(Stream.of(certificate));
    }

    public KeyStoreBuilder containing(X509Certificate certificate, String alias) {
        return this.containing(Stream.of(certificate), (? super X509Certificate c) -> alias);
    }

    public KeyStoreBuilder containing(Collection<X509Certificate> certificates) {
        return this.containing(certificates.stream());
    }

    public KeyStoreBuilder containing(Stream<X509Certificate> certificates) {
        return this.containing(certificates, DEFAULT_ALIAS_CREATOR);
    }

    public KeyStoreBuilder containing(Stream<X509Certificate> certificates, Function<? super X509Certificate, String> aliasCreator) {
        certificates.forEach(cert -> {
            String alias = (String)aliasCreator.apply((X509Certificate)cert);
            this.certificates.merge(alias, (X509Certificate)cert, (existing, collision) -> {
                throw new DuplicateAlias(alias, (Certificate)existing, (Certificate)collision);
            });
        });
        return this;
    }

    public KeyStoreBuilder loadFromClasspath(String classpathResourceName) {
        if (classpathResourceName == null) {
            throw new IllegalArgumentException("Classpath resource name is null");
        }
        this.keyStoreClasspathResourceName = classpathResourceName.replaceFirst("^/(?=.+)", "");
        this.keyStoreStream = null;
        return this;
    }

    public KeyStoreBuilder loadFrom(InputStream keyStoreStream) {
        if (keyStoreStream == null) {
            throw new IllegalArgumentException("Key store InputStream is null. Please specify a stream with data.");
        }
        this.keyStoreStream = keyStoreStream;
        this.keyStoreClasspathResourceName = null;
        return this;
    }

    public KeyStore withNoPassword() {
        return this.withPassword((char[])null);
    }

    public KeyStore withPassword(String password) {
        return this.withPassword(password == null ? null : password.toCharArray());
    }

    public KeyStore withPassword(char[] password) {
        KeyStore initializedKeyStore = this.initNewKeyStore((newKeyStore, content) -> newKeyStore.load(content.orElse(null), password));
        if (!this.certificates.isEmpty()) {
            try {
                for (Map.Entry<String, X509Certificate> certificate : this.certificates.entrySet()) {
                    String alias = certificate.getKey();
                    if (initializedKeyStore.isCertificateEntry(alias)) {
                        throw new DuplicateAlias(alias, initializedKeyStore.getCertificate(alias), certificate.getValue());
                    }
                    initializedKeyStore.setCertificateEntry(alias, certificate.getValue());
                }
            }
            catch (KeyStoreException e) {
                throw new DigipostSecurityException(e);
            }
        }
        return initializedKeyStore;
    }

    private KeyStore initNewKeyStore(KeyStoreInitializer initializeKeyStore) {
        try {
            KeyStore newKeyStore = KeyStore.getInstance(this.type.typeName);
            if (this.keyStoreClasspathResourceName != null) {
                try (InputStream keyStoreStream = KeyStoreBuilder.class.getClassLoader().getResourceAsStream(this.keyStoreClasspathResourceName);){
                    if (keyStoreStream == null) {
                        throw new IllegalArgumentException("Unable to locate " + this.keyStoreClasspathResourceName + " on classpath");
                    }
                    initializeKeyStore.apply(newKeyStore, Optional.of(keyStoreStream));
                }
            } else {
                initializeKeyStore.apply(newKeyStore, Optional.ofNullable(this.keyStoreStream));
            }
            return newKeyStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new DigipostSecurityException("Unable to load key store instance of type " + this + ", because " + e.getClass().getSimpleName() + ": '" + e.getMessage() + "'", e);
        }
    }

    private static interface KeyStoreInitializer {
        public void apply(KeyStore var1, Optional<InputStream> var2) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException;
    }
}

