/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.ocsp;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;

public final class OcspResult
implements Closeable {
    public final URI uri;
    public final CloseableHttpResponse response;

    OcspResult(URI uri, CloseableHttpResponse response) {
        this.uri = uri;
        this.response = response;
    }

    public BasicOCSPResp getResponseObject() throws OCSPException, IllegalStateException, IOException {
        OCSPResp oresp = new OCSPResp(this.response.getEntity().getContent());
        return (BasicOCSPResp)oresp.getResponseObject();
    }

    public boolean isOkResponse() {
        return this.response.getStatusLine().getStatusCode() == 200;
    }

    @Override
    public void close() throws IOException {
        this.response.close();
    }
}

