/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security.ocsp;

import java.net.URI;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Optional;
import java.util.stream.Stream;
import no.digipost.security.DigipostSecurity;
import no.digipost.security.ocsp.OcspLookupRequest;
import no.digipost.security.ocsp.Sha1Calculator;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.operator.DigestCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OcspUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OcspUtils.class);
    private static final ASN1Sequence ASN1_OCSP_SIGNING = new DERSequence((ASN1Encodable)new ASN1ObjectIdentifier("1.3.6.1.5.5.7.3.9"));
    private static final ASN1ObjectIdentifier ASN1_EXTENDED_KEY_USAGE = new ASN1ObjectIdentifier("2.5.29.37");
    private static final String AUTHORITY_INFO_ACCESS_OID = "1.3.6.1.5.5.7.1.1";
    private static final JcaX509CertificateConverter JCA_X509_CERTIFICATE_CONVERTER = new JcaX509CertificateConverter().setProvider("BC");

    public static Optional<URI> findOcspResponderUrl(X509Certificate certificate) {
        byte[] authorityInfoAccessValue = certificate.getExtensionValue(AUTHORITY_INFO_ACCESS_OID);
        if (authorityInfoAccessValue == null) {
            return Optional.empty();
        }
        try {
            ASN1OctetString base = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])authorityInfoAccessValue);
            ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])base.getOctets());
            Enumeration objects = seq.getObjects();
            while (objects.hasMoreElements()) {
                ASN1Encodable id;
                ASN1Encodable elm = (ASN1Encodable)objects.nextElement();
                if (!(elm instanceof ASN1Sequence) || !OCSPObjectIdentifiers.id_pkix_ocsp.equals(id = ((ASN1Sequence)elm).getObjectAt(0))) continue;
                ASN1TaggedObject dt = (ASN1TaggedObject)((DLSequence)elm).getObjectAt(1);
                ASN1OctetString dos = (ASN1OctetString)dt.getObjectParser(dt.getTagNo(), true);
                return Optional.of(URI.create(new String(dos.getOctets())));
            }
            LOG.warn("Failed to extract OCSP uri from " + DigipostSecurity.describe(certificate) + ", because Object identifier " + OCSPObjectIdentifiers.id_pkix_ocsp + " not found");
            return Optional.empty();
        }
        catch (Exception e) {
            LOG.warn("Error when trying to find Object identifier " + OCSPObjectIdentifiers.id_pkix_ocsp + " to extract OCSP uri from " + DigipostSecurity.describe(certificate) + ": " + e.getClass().getSimpleName() + " - '" + e.getMessage() + "'", (Throwable)e);
            return Optional.empty();
        }
    }

    public static Optional<X509Certificate> findOscpSigningCertificate(BasicOCSPResp basix) {
        if (basix.getCerts() != null && basix.getCerts().length > 0) {
            Optional<X509Certificate> ocspSigningCertificate = Stream.of(basix.getCerts()).filter(cert -> Optional.of(cert).map(X509CertificateHolder::getExtensions).map(exts -> exts.getExtension(ASN1_EXTENDED_KEY_USAGE)).map(Extension::getParsedValue).map(ASN1Encodable::toASN1Primitive).filter(arg_0 -> ((ASN1Sequence)ASN1_OCSP_SIGNING).equals(arg_0)).isPresent()).map(OcspUtils::getCertificateFromHolder).findFirst();
            if (!ocspSigningCertificate.isPresent()) {
                LOG.warn("OCSP response contained certificates, but none of them have OCSP signing extended key usage (identifier {})", (Object)ASN1_EXTENDED_KEY_USAGE.getId());
            }
            return ocspSigningCertificate;
        }
        return Optional.empty();
    }

    static final X509Certificate getCertificateFromHolder(X509CertificateHolder holder) {
        try {
            return JCA_X509_CERTIFICATE_CONVERTER.getCertificate(holder);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Error retrieving " + X509Certificate.class.getName() + " from BouncyCastle " + X509CertificateHolder.class.getSimpleName() + ". Reason: " + e.getMessage(), e);
        }
    }

    private OcspUtils() {
    }

    static Optional<CertificateID> tryCreateCertificateId(X509Certificate certificate, X509Certificate issuer) {
        try {
            return Optional.of(new CertificateID((DigestCalculator)new Sha1Calculator(), (X509CertificateHolder)new JcaX509CertificateHolder(issuer), certificate.getSerialNumber()));
        }
        catch (CertificateEncodingException | OCSPException e) {
            OcspLookupRequest.LOG.warn("Failed to create certificate ID from certificate: {}, issued by {}", new Object[]{DigipostSecurity.describe(certificate), DigipostSecurity.describe(issuer), e});
            return Optional.empty();
        }
    }
}

