/*
 * Decompiled with CFR 0.152.
 */
package no.digipost.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.crypto.Cipher;
import no.digipost.security.DigipostSecurityException;
import no.digipost.security.IllegalCertificateType;
import no.digipost.security.cert.CertificateNotFound;
import no.digipost.security.keystore.KeyStoreType;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DigipostSecurity {
    public static final String PROVIDER_NAME = "BC";
    public static final String PKIX = "PKIX";
    public static final String X509 = "X.509";
    private static final Logger LOG = LoggerFactory.getLogger(DigipostSecurity.class);
    private static volatile boolean securityProviderSet = false;
    private static volatile boolean cryptoPolicyPropertySet = false;

    public static CertificateFactory getX509CertificateFactory() {
        try {
            return CertificateFactory.getInstance(X509);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Could not create X.509 certificate factory: '" + e.getMessage() + "'. Available providers: " + Stream.of(Security.getProviders()).map(Provider::getName).collect(Collectors.joining(", ")), e);
        }
    }

    public static X509Certificate readCertificate(String resourceName) {
        return DigipostSecurity.readCertificates(resourceName).findFirst().orElseThrow(() -> new CertificateNotFound(resourceName));
    }

    public static X509Certificate readCertificate(byte[] certificateBytes) {
        return DigipostSecurity.readCertificate(new ByteArrayInputStream(certificateBytes));
    }

    public static X509Certificate readCertificate(InputStream certificateResource) {
        return DigipostSecurity.readCertificates(certificateResource).findFirst().orElseThrow(() -> new CertificateNotFound());
    }

    public static Stream<X509Certificate> readCertificates(String resourceName) {
        Stream<X509Certificate> stream;
        block8: {
            InputStream certificateResource = Objects.requireNonNull(DigipostSecurity.class.getClassLoader().getResourceAsStream(resourceName), resourceName + " not found on classpath!");
            try {
                stream = DigipostSecurity.readCertificates(certificateResource);
                if (certificateResource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (certificateResource != null) {
                        try {
                            certificateResource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading certificate from " + resourceName + ": " + e.getMessage(), e);
                }
            }
            certificateResource.close();
        }
        return stream;
    }

    public static Stream<X509Certificate> readCertificates(byte[] certificatesBytes) {
        return DigipostSecurity.readCertificates(new ByteArrayInputStream(certificatesBytes));
    }

    public static Stream<X509Certificate> readCertificates(InputStream certificatesResource) {
        try {
            return DigipostSecurity.getX509CertificateFactory().generateCertificates(certificatesResource).stream().map(DigipostSecurity::requireX509);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Unable to generate certificate: " + e.getMessage(), e);
        }
    }

    public static X509Certificate requireX509(Certificate certificate) {
        if (certificate instanceof X509Certificate) {
            return (X509Certificate)certificate;
        }
        throw new IllegalCertificateType(certificate);
    }

    public static Stream<X509Certificate> asStream(CertPath path) {
        return path.getCertificates().stream().map(DigipostSecurity::requireX509);
    }

    @Deprecated
    public static KeyStore asKeyStore(Iterable<X509Certificate> certificates) {
        return KeyStoreType.JCEKS.newKeyStore().containing(StreamSupport.stream(certificates.spliterator(), false), cert -> cert.getSubjectDN().toString()).withNoPassword();
    }

    public static CertPath asCertPath(Stream<X509Certificate> certificates) {
        List collectedCertificates = certificates.collect(Collectors.toList());
        try {
            return DigipostSecurity.getX509CertificateFactory().generateCertPath(collectedCertificates);
        }
        catch (CertificateException e) {
            throw new DigipostSecurityException(e);
        }
    }

    public static String describe(CertPath certPath) {
        if (certPath == null) {
            return "(null)";
        }
        List<? extends Certificate> certificates = certPath.getCertificates();
        if (!certificates.isEmpty()) {
            return certificates.stream().map(DigipostSecurity::describe).collect(Collectors.joining("\n ^-- Issued by: ", "CertPath with the following certificates:\nCertificate: ", ""));
        }
        return "CertPath with no certificates";
    }

    public static String describe(Certificate certificate) {
        if (certificate == null) {
            return "(null)";
        }
        if (certificate instanceof X509Certificate) {
            X509Certificate x509 = (X509Certificate)certificate;
            String subjectDescription = x509.getSubjectX500Principal().getName("RFC1779");
            String validityDescription = "valid from " + x509.getNotBefore().toInstant() + " to " + x509.getNotAfter().toInstant();
            String serialNumberDescription = "serial-number: " + x509.getSerialNumber().toString(16);
            String issuerDescription = x509.getSubjectX500Principal().equals(x509.getIssuerX500Principal()) ? "self-issued" : "issuer: " + x509.getIssuerX500Principal().getName("RFC1779");
            return String.join((CharSequence)", ", subjectDescription, validityDescription, serialNumberDescription, issuerDescription);
        }
        return certificate.getType() + "-certificate";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void ensureSecurityProvider() {
        DigipostSecurity.ensureCryptoPolicyUnlimited();
        if (securityProviderSet) return;
        Class<Security> clazz = Security.class;
        synchronized (Security.class) {
            if (Security.getProvider(PROVIDER_NAME) != null) return;
            Security.addProvider((Provider)new BouncyCastleProvider());
            securityProviderSet = true;
            LOG.info("Security provider BC added: " + BouncyCastleProvider.class.getName());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void ensureCryptoPolicyUnlimited() {
        if (!cryptoPolicyPropertySet) {
            Security.setProperty("crypto.policy", "unlimited");
            cryptoPolicyPropertySet = true;
            LOG.info("Security policy set: crypto.policy=unlimited");
        }
    }

    public static void verifyJceUnlimitedStrength() {
        try {
            int aesMaxKeyLength = Cipher.getMaxAllowedKeyLength("AES");
            if (aesMaxKeyLength != Integer.MAX_VALUE) {
                throw new DigipostSecurityException("Java Cryptography Extension (JCE) Unlimited Strength not enabled! Maximum allowed key length for AES is " + aesMaxKeyLength);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigipostSecurityException("Error when verifying the maximum key length for the AES algorithm. Is Java Cryptography Extension (JCE) Unlimited Strength enabled?", e);
        }
    }

    private DigipostSecurity() {
    }

    static {
        DigipostSecurity.ensureSecurityProvider();
    }
}

